//**************************************************************************
//
// Copyright (c) 1997.
//      Richard D. Irwin, Inc.
//
// This software may not be distributed further without permission from
// Richard D. Irwin, Inc.
//
// This software is distributed WITHOUT ANY WARRANTY. No claims are made
// as to its functionality or purpose.
//
// Authors: James P. Cohoon and Jack W. Davidson
// Date: 7/15/96
// $Revision: 1.2 $
// $Name: $
//
//**************************************************************************
// Class Position implementation


#include "position.h"

Position::Position(const float x, const float y) : XDistance(x), YDistance(y) {
	// No function body required
}

float Position::GetXDistance() const {
	return XDistance;
}

float Position::GetYDistance() const {
	return YDistance;
}

void Position::SetXDistance(const float x) {
	XDistance = x;
	return;
}

void Position::SetYDistance(const float y) {
	YDistance = y;
	return;
}

Position operator+(const Position &x, const Position &y) {
	return Position(x.GetXDistance() + y.GetXDistance(),
									x.GetYDistance() + y.GetYDistance());
}

Position operator-(const Position &x, const Position &y) {
   return Position(x.GetXDistance() - y.GetXDistance(),
                           x.GetYDistance() - y.GetYDistance());
}

