#include <iostream>
#include <vector>
#include <string>

using namespace std;



typedef  enum {A,B} specie;
typedef  enum {Nord,Est,Sud,Ovest} direzione;

 

const double p = 0.5; //Probabilita` di creare una particella
const double a = 0.9; //Probabilita di andare nella direzione della forza 
const int dimAutomaR = 30;  //Dimensione automa
const int dimAutomaC = 30;  //Dimensione automa
const int maxNumeroCicli = 100; //Numero cicli di aggiornamento

float randUni(); // Restituisce un random nell' intervallo (0,1)  
void randomize(); //Randomizza la catena paseudocasuale utilizzando time 

// cella 
class Cella {
public:
	// costruttore
    Cella();
	// randomizzatori
	void randomOccup();
	void randomDir();
	// inspectors
	bool getOccupato();
	specie getParticella();
	// la direzione della particella (se ce' !!)
	direzione rivoltoA();
	bool rivoltoANord();
	bool rivoltoAEst();
	bool rivoltoASud();
	bool rivoltoAOvest();
	// chi si affaccia sulla cella
	bool siAffacciaDaNord(int r, int c); 
	bool siAffacciaDaEst(int r, int c); 
	bool siAffacciaDaSud(int r, int c); 
	bool siAffacciaDaOvest(int r, int c); 
	int siAffaccianoIn(int r,int c);
	// facilitatori
	void stampaCella();
	// modificatori
	int applicaRegole(int r, int c);
	void aggiornaCella();
private:
	// stato attuale
	bool occupato;
	specie particella;
	direzione orientamento;
	bool cambiato;           // lo stato e' cambiato
	// nuovo stato
	bool nuovoStatoOccupato;
	specie nuovoStatoParticella; 
};

class Automa {

public:

// Costruttore 		
	Automa(int dimR,int dimC) ;
// ritorna un reference alla cella r,c 
	//(tiene conto delle dimensioni della Automa))
	Cella &Automa::getCella(int r,int c);	
	// visualizza l Automa come matrice di {' ',A,B}
	void visualizza() ;	
	// dopo aver calcolato il nuovo stato per tutte le celle 
	// si procede all' aggiornamento in modo sincrono della Automa
	void aggiornaCelle() ;
	// un  ciclo di aggiornamento e calcoli statistiche
	void cicloAggiornamento(int numCiclo);
// autocorrelazione
	void autocorrelazione();

private:
	vector < vector < Cella > > Griglia;
	int numRighe;
	int numColonne;

};


class Statistica {

private:
	int A_N;
	int A_E;
	int A_S;
	int A_O;
	int B_N;
	int B_E;
	int B_S;
	int B_O;
	int TOT;
	

public:
	Statistica();
	void reset();
	void aggiorna(specie s, direzione d);
	void stampa();
};


