#include <time.h>
#include <iostream>
#include <vector>
#include <string>
#include <stdlib.h>
#include "diffusione.h"
using namespace std;

// Restituisce un random nell' intervallo (0,1) 
float randUni() {
	return (float)rand()/(float)RAND_MAX;
}

//Randomizza la catena paseudocasuale utilizzando time
void randomize() {
	srand( (unsigned)time( NULL ) );
}

// variabili gloabali 

bool debug =false;
Automa g(dimAutomaR,dimAutomaC);
Statistica stat;

// Cella

Cella::Cella(){
		cambiato=false;
	}

void Cella::randomOccup(){
	float sorteggio = randUni();
	if (sorteggio < 0.5 *p) {
		occupato=true;
	    particella=A;
	}
	else if (sorteggio < p) {
		occupato=true;
	    particella=B;
	}
	else occupato=false;
}

// direzione della forza Sud-Est
void Cella::randomDir(){
	float sorteggio=randUni();
	if (particella==A) {
		if(sorteggio < 0.5 * a) orientamento=Est;
        else if (sorteggio < a) orientamento=Nord;
		else if (sorteggio < a+0.5*(1-a)) orientamento=Ovest;
		else orientamento=Sud;
	}
	else {
		if(sorteggio < 0.5 * (1-a)) orientamento=Est;
        else if (sorteggio < (1-a)) orientamento=Nord;
		else if (sorteggio < (1-a)+0.5*a) orientamento=Ovest;
		else orientamento=Sud;
	}
}



bool Cella::getOccupato(){
	return occupato;
}

specie Cella::getParticella(){
	return particella;
}

bool Cella::siAffacciaDaNord(int r, int c) {
	return (g.getCella(r+1,c).getOccupato()) &&
		(g.getCella(r+1,c).rivoltoASud());
}

bool Cella::siAffacciaDaEst(int r, int c) {
	return (g.getCella(r,c+1).getOccupato()) &&
		(g.getCella(r,c+1).rivoltoAOvest()); 
}

bool Cella::siAffacciaDaSud(int r, int c) {
	return (g.getCella(r-1,c).getOccupato()) &&
		(g.getCella(r-1,c).rivoltoANord()); 
}

bool Cella::siAffacciaDaOvest(int r, int c) {
	return (g.getCella(r,c-1).getOccupato()) &&
		(g.getCella(r,c-1).rivoltoAEst());
}

int Cella::siAffaccianoIn(int r,int c) {
	int num = 0;	
	if (siAffacciaDaNord(r,c)) num=num+ 1; //Nord 
	if (siAffacciaDaEst(r,c)) num=num+ 1; //Est 
    if (siAffacciaDaSud(r,c)) num=num+ 1; //Sud
	if (siAffacciaDaOvest(r,c)) num=num+ 1; //Ovest 

	if ((num>0) && debug) cout<<endl<<"siAffacciano( "<< r << ", " << c << ", " << num << ") "<<endl;
	return num;
}
	

direzione Cella::rivoltoA() {
	return orientamento;
}

bool Cella::rivoltoANord() {
	return (orientamento==Nord);
}
bool Cella::rivoltoAEst() {
	return (orientamento==Est);
}
bool Cella::rivoltoASud() {
	return (orientamento==Sud);
}
bool Cella::rivoltoAOvest() {
	return (orientamento==Ovest);
}


// applica le regole alla cella in posizione r,c
// peer il debug ritorna come intero il numero di regola usata
	
int Cella::applicaRegole(int r, int c) {
	

	if (occupato) {                 //la cella e' occupata	
		direzione dir=rivoltoA();
		int r_davanti;
		int c_davanti;
		if (dir==Nord) {
			r_davanti=r+1;
			c_davanti=c;
		}
		else if (dir==Est) {
			r_davanti=r;
			c_davanti=c+1;
		}
		else if (dir==Sud) {
			r_davanti=r-1;
			c_davanti=c;
		}
		else if (dir==Ovest) {
			r_davanti=r;
			c_davanti=c-1;
		}
// 1) una particella rivolta verso un sito occupato
// non si deve muovere
		if (g.getCella(r_davanti,c_davanti).occupato) {
			return 1;
		}

// 2) una particella rivolta verso un sito vuoto su cui 		
// si affacciano altre particelle non si deve muovere
		


		else if(siAffaccianoIn(r_davanti,c_davanti)> 1) {
			return 2;
		}
// 3) una particella rivolta verso un sito vuoto su cui 
// non si affacciano altre particelle si libera
		else {
			nuovoStatoOccupato=false;
			cambiato=true;
			stat.aggiorna(particella,orientamento);
			return 3;
		}
	}
	else {     // cella vuota

		// 4) un sito vuoto su cui si affacci una 
		// sola particella diventa pieno
		if (siAffaccianoIn(r,c)==1) {
			if (siAffacciaDaNord(r,c)) {
				nuovoStatoOccupato=true;
				nuovoStatoParticella=g.getCella(r+1,c).particella;
				cambiato=true;
			}
			else if (siAffacciaDaEst(r,c)) {
				nuovoStatoOccupato=true;
				nuovoStatoParticella=g.getCella(r,c+1).particella;
				cambiato=true;
			}
			else if (siAffacciaDaSud(r,c)) {
				nuovoStatoOccupato=true;
				nuovoStatoParticella=g.getCella(r-1,c).particella;
				cambiato=true;
			}
			else if (siAffacciaDaOvest(r,c)) {
				nuovoStatoOccupato=true;
				nuovoStatoParticella=g.getCella(r,c-1).particella;
				cambiato=true;
			}
			return 4;
		}
		// 5) la cella e' vuota non si affaccia nessuna particella
		// oppure si affacciano 2 o piu particelle
		// la cella rimane vuota
		else {
			return 5;
		}
	}

}



void Cella::aggiornaCella() {
	if (cambiato) {
		occupato=nuovoStatoOccupato;
		particella=nuovoStatoParticella;
		cambiato=false;
	}
	if (occupato) randomDir();
}

void Cella::stampaCella() {
	if(occupato) {
		if (particella==A) {
			cout << 'A';
		}
		else {
			cout << 'B';
		}
	}
	else{
		cout << ' ';
	}
}



// AUTOMA

Automa::Automa(int dimR,int dimC) {
	    randomize();
		numRighe=dimR;
		numColonne=dimC;
		// dimensiona la griglia
	    Griglia.resize(numRighe,vector<Cella>(numColonne,Cella()));
		// inizializza le celle
		for (int riga=0; riga < numRighe; riga++) {
			for (int colonna=0; colonna < numColonne; colonna++) {
				Griglia[riga][colonna].randomOccup() ;
				Griglia[riga][colonna].randomDir() ;
			}
		}
	}
	
// Restituisce un reference alla cella 
// Tiene conto delle dimensioni dell' automa
Cella &Automa::getCella(int r, int c){
	 r=(r+numRighe)%numRighe;
	 c=(c+numColonne)%numColonne;
	 return (Cella &) Griglia[r][c];
}


// AUTOMA 
	// visualizza la Automa 
void Automa::visualizza() {
		for (int riga=0; riga < numRighe; riga++) {
			for (int colonna=0; colonna < numColonne; colonna++) {
				Griglia[riga][colonna].stampaCella() ;
			}
			cout << endl;
		}
	cout << endl;
	}


	// dopo aver calcolato il nuovo stato per tutte le celle 
	// si procede all' aggiornamento in modo sincrono della Automa
void Automa::aggiornaCelle() {
		int riga,colonna,numRegola;
		for (riga=0; riga < numRighe; riga++) {
			for (colonna=0; colonna < numColonne; colonna++) {
				numRegola=Griglia[riga][colonna].applicaRegole(riga,colonna);
				if (debug){
					cout <<"posizione " << riga << colonna << "regola " ;
					cout <<	numRegola << endl;
				}
			}
		}
		for (riga=0; riga < numRighe; riga++) {
			for (colonna=0; colonna < numColonne; colonna++) {
				Griglia[riga][colonna].aggiornaCella() ;
			}
		}
	}


// autocorrelazione
	void Automa::autocorrelazione() {
		int autoc;
		bool o1,o2;
		specie p1,p2;
		cout << " autoc " ;
		for (int h=0; h < 30; h++) {
			autoc=0;
			for(int r=0; r< numRighe; r++) {
				for (int c=0; c< numColonne; c++) {
					o1=Griglia[r][c].getOccupato();
					o2=getCella(r+h,c+h).getOccupato();
					p1=Griglia[r][c].getParticella();
					p2=getCella(r+h,c+h).getParticella();
					if (o1&&o2){ //entrambe occupate
						if (p1==p2) { //stessa specie
							autoc++;
						}
						else { //specie diversa
							autoc--;
						}
					}
				}
			}
			cout << " " << autoc ;
		}
		cout<<endl;
	}


	// un sequenza di cicli di aggiornamento e relativa visualizzazione
void Automa::cicloAggiornamento(int numCiclo){
	    stat.reset();
		aggiornaCelle();
		cout << numCiclo << " " ;
		stat.stampa(); 
	}



Statistica::Statistica(){
	reset();
}
	
void Statistica::reset(){
	A_N=0;
	A_E=0;
	A_S=0;
	A_O=0;
	B_N=0;
	B_E=0;
	B_S=0;
	B_O=0;
	TOT=0;
}



void Statistica::aggiorna(specie s, direzione d){
	if (s==A) {
		switch (d) {
			case Nord:A_N++; break;
			case Est:A_E++; break;
			case Sud:A_S++; break;
			case Ovest:A_O++; break;
		}
	}
	else {
		switch (d) {
			case Nord:B_N++; break;
			case Est:B_E++; break;
			case Sud:B_S++; break;
			case Ovest:B_O++; break;
		}
	}
}

	
void Statistica::stampa(){
	TOT= A_N + A_E - A_S - A_O - B_N - B_E + B_S + B_O;
	cout << " A_N " << A_N <<" A_E " << A_E ;
    cout << " A_S " << A_S <<" A_O " << A_O ;
	cout << " B_N " << B_N <<" B_E " << B_E ;
    cout << " B_S " << B_S <<" B_O " << B_O ;
	cout << " TOT " << TOT << endl;
}

void main(){
	
	cout << "Stato Iniziale " << endl;	
	g.visualizza();
	g.autocorrelazione();
	for (int i=0; i<maxNumeroCicli; i++) { 
		g.cicloAggiornamento(i);
	}
	cout << "Stato Finale " << endl;
	g.visualizza();
	g.autocorrelazione();
	cin.get();
	cout << "Premi un tasto per finire " << flush ;
	cin.get();
}


