/*   
    Dario Bianchi ottobre 2002

  Plot della funzione logistica

  x[i+1] = lambda * (1 - x[i]) * x[i]

  Calcola anche un istogramma della popolazione 
	
	  Usa EZWIN per la grafica  

*/


#include <fstream>
#include <iostream>
#include <string>
#include <vector>
#include "rect.h"
#include "ray.h"
using namespace std;




// rappresenta un punto da graficare //
class Point {
public:
	float x;
	float y;
	Point() {
		x=0;
		y=0;
	}
	Point(double xVal, double yVal) {
		x=xVal;
		y=yVal;
	}

};

/* determina i fattori di scala, scala il vettore da graficare e 
   disegna gli assi */

void scala(SimpleWindow &W, vector<Point> &Vect) {
	float WinDimX = W.GetWidth() - 1;
    float WinDimY = W.GetHeight() - 1;
	
	float xOffSet =0.5;
	float yOffSet =0.5; 
	float thick = 0.015;
	// determina massimi e minimi di x e y
	float xMin=Vect[0].x;
	float xMax=Vect[0].x;
	float yMin=Vect[0].y;
	float yMax=Vect[0].y;
	for (int i=1; i < Vect.size(); i++) {
		if (Vect[i].x < xMin) xMin=Vect[i].x;
		if (Vect[i].x > xMax) xMax=Vect[i].x;
		if (Vect[i].y < yMin) yMin=Vect[i].y;
		if (Vect[i].y > yMax) yMax=Vect[i].y;
	}

	// informa sugli assi
	cout << "Determinazione dei fattori di scala per il Plot " << endl;
	cout << "asse X da " << xMin << " a " << xMax << endl; 
    cout << "asse Y da " << yMin << " a " << yMax << endl;
	// Scala le coppie x,y
	for (i=0; i < Vect.size(); i++) {
		Vect[i].x= xOffSet + (Vect[i].x-xMin) / (xMax-xMin) * WinDimX;
		Vect[i].y= yOffSet + WinDimY - (Vect[i].y-yMin) / (yMax-yMin) * WinDimY;
	//	cout << '[' << i << "] " << Vect[i].x <<" "<< Vect[i].y << endl;
	}
	// Traccia gli assi

	RaySegment asseX(W,Position(xOffSet,yOffSet+WinDimY),Position(xOffSet,yOffSet),Black,0.1,true);
	RaySegment asseY(W,Position(xOffSet,yOffSet+WinDimY),Position(xOffSet+WinDimX,yOffSet+WinDimY),Black,0.1,true);
	asseX.Draw();
	asseY.Draw();

}


// costruisce il grafico
void mostraDati(SimpleWindow &W, vector<Point> &Vect) {
	scala(W,Vect);
	const float Unit=0.1;
	for (int i=0; i < Vect.size(); i++) {
		RectangleShape R(W,Vect[i].x,Vect[i].y, Red, Unit, Unit);
		R.Draw();
	}
}



//Calcolo della funzione logistica)
double logistica (float lambda, double x) {
	return ((double)lambda * (1.0-x) * x);
}


/* Una simulazione

lambda: parametro della funzione logistica
NPunti: numero di punti per la simulazione
start: popol;azione iniziale
Vect: vettore popolazione x=tempo (n. ciclo) y= popolazione

*/  
void simula_logistica(float lambda, int NPunti, 
					  float start, vector<Point> &Vect) {
	Vect.resize(0);
	Vect.push_back(Point(0.0,start));
	double last = start;
	for (int i=0; i < NPunti; i++) {
		last=logistica(lambda,last);
		Vect.push_back(Point((float)(i+1),(float) last));
		cout << '[' << i << "] " << Vect[i].x <<" "<< Vect[i].y << endl;
	}	
}


/* calcola l' istogramma della popolazione

  Dati contiene i dati di una simulazione, Istogramma il risultato
  L' istogramma viene calcolato 
  dividendo in cento parti l' intervallo 0-1 della popolazione
  I primi 30 dati della simulazione vengono scartati
*/

void calcola_istogramma(vector<Point> &Dati, vector<Point> &Istogramma) {
	int k; // un valore 0-99
	// inzializza uyn istogramma di 100 punti con frequenze = 0 
	Istogramma.resize(100);
	for (int i=0; i<100; i++) {
		Istogramma[i]=Point(i,0);
	}
	// accumula le frequenze di polazione (scarta i primi 30 punti)
	for (i=30; i<Dati.size(); i++) {
		k= 100*Dati[i].y;  //valore di popolazione scalato a in 0-99
		Istogramma[k].y=Istogramma[k].y+1;
	}
}


// Per graficare la simulazione
SimpleWindow W("Plot Dati",20,10);
// per graficare l' istogramma
SimpleWindow W2("Plot Dati",10,10);

int ApiMain() {
	 float lambda ;	
     vector<Point> Dati;	// per i dati della simulazione
	 vector<Point> Istogramma;	// istogramma
	  // legge il parametro
	 cout << "calcolo della funzione logistica" << endl;
	 cout << "valore del parametro lambda " << flush;
	 cin >> lambda;
	 // effettua una simulazione e calcola istogramma
	 simula_logistica(lambda,100,0.1,Dati);
	 calcola_istogramma(Dati,Istogramma);

	 // grafica
	 W.Open();
	 W2.Open();

	 mostraDati(W,Dati); 
	 mostraDati(W2,Istogramma);
	 
	 cout << " CTRL-C per teminare il programma!!!"  << endl;
	 return 0;
}