

/*   
    Dario Bianchi ottobre 2002

  Plot della funzione logistica

  x[i+1] = lambda * (1 - x[i]) * x[i]

  Plot di popolazione in funzione di lambda
  si ottiene una mappa che evidenzia le biforcazioni.

  Metodo usato:

  per ogni valore di lambda (fra 1 e 4) si calcolano 1000 iterazioni
  le successive 32 iterazioni vengono memorizzate e graficate
  per lambda > 4 non si riesce a effettuare il calcolo!!!!!!!	
	  
		Usa EZWIN per la grafica  

*/

#include <fstream>
#include <iostream>
#include <string>
#include <vector>
#include "rect.h"
#include "ray.h"
using namespace std;




// rappresenta un punto da graficare //
class Point {
public:
	float x;
	float y;
	Point() {
		x=0;
		y=0;
	}
	Point(double xVal, double yVal) {
		x=xVal;
		y=yVal;
	}

};

/* determina i fattori di scala, scala il vettore da graficare e 
   disegna gli assi */

void scala(SimpleWindow &W, vector<Point> &Vect) {
	float WinDimX = W.GetWidth() - 1;
    float WinDimY = W.GetHeight() - 1;
	
	float xOffSet =0.5;
	float yOffSet =0.5; 
	float thick = 0.015;
	// determina massimi e minimi di x e y
	float xMin=Vect[0].x;
	float xMax=Vect[0].x;
	float yMin=Vect[0].y;
	float yMax=Vect[0].y;
	for (int i=1; i < Vect.size(); i++) {
		if (Vect[i].x < xMin) xMin=Vect[i].x;
		if (Vect[i].x > xMax) xMax=Vect[i].x;
		if (Vect[i].y < yMin) yMin=Vect[i].y;
		if (Vect[i].y > yMax) yMax=Vect[i].y;
	}
	
	// informa sugli assi
	cout << "Determinazione dei fattori di scala per il Plot " << endl;
	cout << "asse X da " << xMin << " a " << xMax << endl; 
    cout << "asse Y da " << yMin << " a " << yMax << endl;
	// Scala le coppie x,y
	for (i=0; i < Vect.size(); i++) {
		Vect[i].x= xOffSet + (Vect[i].x-xMin) / (xMax-xMin) * WinDimX;
		Vect[i].y= yOffSet + WinDimY - (Vect[i].y-yMin) / (yMax-yMin) * WinDimY;
	//	cout << '[' << i << "] " << Vect[i].x <<" "<< Vect[i].y << endl;
	}
	// Traccia gli assi

	RaySegment asseX(W,Position(xOffSet,yOffSet+WinDimY),Position(xOffSet,yOffSet),Black,0.1,true);
	RaySegment asseY(W,Position(xOffSet,yOffSet+WinDimY),Position(xOffSet+WinDimX,yOffSet+WinDimY),Black,0.1,true);
	asseX.Draw();
	asseY.Draw();

}


// costruisce il grafico
void mostraDati(SimpleWindow &W, vector<Point> &Vect) {
	scala(W,Vect);
	const float Unit=0.1;
	for (int i=0; i < Vect.size(); i++) {
		RectangleShape R(W,Vect[i].x,Vect[i].y, Red, Unit, Unit);
		R.Draw();
	}
}



//Calcolo della funzione logistica)
double logistica (float lambda, double x) {
	return ((double)lambda * (1.0-x) * x);
}


// Calcola la mappa
void calcola_mappa(vector<Point> &Vect) {
	Vect.resize(0);
	double start = 0.1;
	// ciclo per lambda da 1 a 4
	for (double lambda =1; lambda < 4; lambda = lambda + 0.01) {
		double last = start;
		// 1000 cicli a vuoto
		for (int i=0; i < 1000; i++) {
			last=logistica(lambda,last);
		}
		// 32 cicli memorizzati popolazione vs. lambda
		for (i=0; i <32;i++) {
			last=logistica(lambda,last);
			Vect.push_back(Point(lambda,(float) last));
			cout << '[' << i << "] " << lambda <<" "<< last << endl;
		}	
	}
}



// finestra per la grafica
SimpleWindow W("Plot Dati",20,10);


int ApiMain() {
	 
     vector<Point> Mappa;
	 calcola_mappa(Mappa);

	 W.Open();
	 
	 mostraDati(W,Mappa); 
	 
	 
	 cout << " CTRL-C per teminare il programma!!!"  << endl;
	 return 0;
}