
/*   
    Dario Bianchi ottobre 2002

  Calcolo di un moto armonico con smorzamento

  
Equazioni

m*dv/dt + ca * v+ k (x-l0) =0

a(t)= (- k *(x-l0)  - ca *v(t) ) / m
v(t+dt) = v(t) + a(t) * dt
x(t + dt) = x(t) + v(t) * dt


Possibili valori iniziali

posizione iniziale	x0 =	1.0	
velocita' iniziale	v0 = 	0.0
massa =1.0
costante elastica della molla	k =	5.0	
coefficiente di attrito	ca =	0.2	
lunghezza a riposo della molla	l0 =2.0	
intervallo di tempo per 1 step	dt = 0,01	





	  
		Usa EZWIN per la grafica  

*/

#include <fstream>
#include <iostream>
#include <string>
#include <vector>
#include "rect.h"
#include "ray.h"
using namespace std;




// rappresenta un punto da graficare //
class Point {
public:
	float x;
	float y;
	Point() {
		x=0;
		y=0;
	}
	Point(double xVal, double yVal) {
		x=xVal;
		y=yVal;
	}

};

/* determina i fattori di scala, scala il vettore da graficare e 
   disegna gli assi */

void scala(SimpleWindow &W, vector<Point> &Vect) {
	float WinDimX = W.GetWidth() - 1;
    float WinDimY = W.GetHeight() - 1;
	
	float xOffSet =0.5;
	float yOffSet =0.5; 
	float thick = 0.015;
	// determina massimi e minimi di x e y
	float xMin=Vect[0].x;
	float xMax=Vect[0].x;
	float yMin=Vect[0].y;
	float yMax=Vect[0].y;
	for (int i=1; i < Vect.size(); i++) {
		if (Vect[i].x < xMin) xMin=Vect[i].x;
		if (Vect[i].x > xMax) xMax=Vect[i].x;
		if (Vect[i].y < yMin) yMin=Vect[i].y;
		if (Vect[i].y > yMax) yMax=Vect[i].y;
	}
	
	// informa sugli assi
	cout << "Determinazione dei fattori di scala per il Plot " << endl;
	cout << "asse X da " << xMin << " a " << xMax << endl; 
    cout << "asse Y da " << yMin << " a " << yMax << endl;
	// Scala le coppie x,y
	for (i=0; i < Vect.size(); i++) {
		Vect[i].x= xOffSet + (Vect[i].x-xMin) / (xMax-xMin) * WinDimX;
		Vect[i].y= yOffSet + WinDimY - (Vect[i].y-yMin) / (yMax-yMin) * WinDimY;
	}
	// Traccia gli assi

	RaySegment asseX(W,Position(xOffSet,yOffSet+WinDimY),Position(xOffSet,yOffSet),Black,0.1,true);
	RaySegment asseY(W,Position(xOffSet,yOffSet+WinDimY),Position(xOffSet+WinDimX,yOffSet+WinDimY),Black,0.1,true);
	asseX.Draw();
	asseY.Draw();

}


// costruisce il grafico
void mostraDati(SimpleWindow &W, vector<Point> &Vect) {
	scala(W,Vect);
	const float Unit=0.1;
	for (int i=0; i < Vect.size(); i++) {
		RectangleShape R(W,Vect[i].x,Vect[i].y, Red, Unit, Unit);
		R.Draw();
	}
}


// rappresenta posizione, velocita` e accelerazione al tempo t

class Stato {
public:
	double t;
	double x;
	double v;


	Stato() {
		t=0;
		x=0;
		v=0;
	}
	Stato(double tVal,double xVal, double vVal) {
		t=tVal;
		x=xVal;
		v=vVal;
	}

};


/*
a(t)= (- k *(x-l0)  - ca *v(t) ) / m
v(t+dt) = v(t) + a(t) * dt
x(t + dt) = x(t) + v(t) * dt
*/


/*
void simula(vector<Stato> &Track ,double x0, double v0, double m, 
			double k, double ca, double l0, double dt, int nPts) {
	double acc;
	cout << "MOTO ARMONICO SMORZATO (con errore !!!!!!)" << endl;
	cout << "Posizione iniziale:" << x0 << " Velocita iniziale: " << v0 << endl;
	cout << " Massa: " << m << " Costante elastica molla: " << k << endl;
	cout << " Coefficiente di attrito: " << ca 	<<" Lunghezza molla " << l0 << endl ;
	cout << " Intervallo dt: " << dt << " Numero punti: " << nPts << endl;
	Track.resize(nPts);
	Track[0]=Stato(0.0,x0,v0);
	for (int i=1;i<nPts;i++) {
		acc =(- k* (Track[i-1].x-l0)  - ca * Track[i-1].v ) / m ;
		Track[i].t = Track[i-1].t + dt;
		Track[i].v = Track[i-1].v + acc * dt ;
		// Attenzione prendere la velocita` al tempo i e non i-1 !!!!!!!!!!
		   Track[i].x = Track[i-1].x + Track[i].v * dt ;
        // Cosi non funziona
		// Track[i].x = Track[i-1].x + Track[i-1].v * dt ;
	}
}

*/


void simula(vector<Stato> &Track ,double x0, double v0, double m, 
			double k, double ca, double l0, double dt, int nPts) {
	double Acc;
    double Velocita;
    double Posizione;

    double nuovaAcc;
    double nuovaVelocita;
    double nuovaPosizione;

	cout << "MOTO ARMONICO SMORZATO" << endl;
	cout << "Posizione iniziale:" << x0 << " Velocita iniziale: " << v0 << endl;
	cout << " Massa: " << m << " Costante elastica molla: " << k << endl;
	cout << " Coefficiente di attrito: " << ca 	<<" Lunghezza molla " << l0 << endl ;
	cout << " Intervallo dt: " << dt << " Numero punti: " << nPts << endl;
	Track.resize(nPts);
	
	// condizioni iniziali
	Track[0]=Stato(0.0,x0,v0);
	Posizione=x0;
	Velocita=v0;
	nuovaPosizione=x0;
	nuovaVelocita=v0;

	for (int i=1;i<nPts;i++) {
// si calcolano 100 punti intermedi con un deltat= dt/100
		for (int k=0; k< 100; k++) {
			Velocita = nuovaVelocita;
			Posizione = nuovaPosizione;
			Acc= (-k * (Posizione - l0) - ca * Velocita ) /m;
			nuovaVelocita = Velocita + Acc * (dt /100.0);
			// le due versioni sono equivalenti
            nuovaPosizione = Posizione + Velocita * (dt /100.0);
			//nuovaPosizione = Posizione + nuovaVelocita * (dt /100.0);
		}
// si memorizza un punto		
		Track[i].t = i * dt;
		Track[i].v = nuovaVelocita; 
		Track[i].x = nuovaPosizione; 
	}
}



void estrai_pos_vel (vector<Stato> &Track,
					 vector<Point> &Posizione,
					 vector<Point> &Velocita) {
	Posizione.resize(Track.size());
	Velocita.resize(Track.size());
	for (int i=0; i<Track.size(); i++){
		Posizione[i].x= (float) Track[i].t;
		Posizione[i].y= (float) Track[i].x;
		Velocita[i].x= (float) Track[i].t;
		Velocita[i].y= (float) Track[i].v;
	}
}


// finestra per la grafica
SimpleWindow W1("Posizione",20,10);
SimpleWindow W2("Velocita",20,10);

int ApiMain() {
	 vector<Stato> Track;
     vector<Point> Posizione;
	 vector<Point> Velocita;
	 float ca;
	 cout << "Coefficiente di attrito (es: 0.2): " << flush;
	 cin >> ca ;
	 
/*
posizione iniziale	x0 =	1.0	
velocita' iniziale	v0 = 	0.0
massa =1.0
costante elastica della molla	k =	5.0	
coefficiente di attrito	ca =	0.4	
lunghezza a riposo della molla	l0 =2.0	
intervallo di tempo per 1 step	dt = 0,01	

  Chiamata del simulatore
	 void simula(vector<Stato> &Track ,float x0, float v0, float m, 
			float k, float ca, float l0, float dt, int nPts) 
*/

	simula(Track , 1.0, 0.0, 1.0, 5.0, ca, 2.0, 0.01, 2000); 
	estrai_pos_vel(Track, Posizione, Velocita);

	 W1.Open();
	 W2.Open();
	 mostraDati(W1,Posizione); 
	 mostraDati(W2,Velocita); 
	 
	 cout << " CTRL-C per teminare il programma!!!"  << endl;
	 return 0;
}