#include "ezwin.h"
#include "position.h"
#include "bitmap.h"
#include <assert.h>
using namespace std;
/* 
Dario Bianchi
novembre 2002
  questo programma mostra una animazione come sequenza di fotogrammi
  tre bottoni permettono di controllare partenza, arresto e uscita dal programma
 */

class Animazione {

public:
// attenzione per passare il reference alla finestra bisogna fare cosi !!!!!
	Animazione(SimpleWindow &Win):W(Win){
	}
// mostra i bottonoi
// carica i 10 fotogrammi delle animazioni (mostra il primo)
	void Init() {		
		assert (W.GetStatus()==WindowOpen);
		TimerRunning=false;
		currentImage=0;
		Wizard.resize(10);
		StartButton.SetWindow(W);
		StopButton.SetWindow(W);
		ExitButton.SetWindow(W);

		Wizard[0].Load("t1.bmp");
		Wizard[1].Load("t2.bmp");
		Wizard[2].Load("t3.bmp");
		Wizard[3].Load("t4.bmp");
		Wizard[4].Load("t5.bmp");
		Wizard[5].Load("t6.bmp");
		Wizard[6].Load("t7.bmp");
		Wizard[7].Load("t8.bmp");
		Wizard[8].Load("t9.bmp");
		Wizard[9].Load("t10.bmp");
		
		Position P=W.GetCenter() + Position(-0.5 * Wizard[1].GetWidth() ,
			                                 -0.5 * Wizard[1].GetHeight());
		for (int i= 0; i<10; i++) {
			Wizard[i].SetWindow(W);
			assert(Wizard[i].GetStatus()==BitMapOkay);
			Wizard[i].SetPosition(P);
		}
		StartButton.Load("StartButton.bmp");
		assert(StartButton.GetStatus()==BitMapOkay);
		StopButton.Load("StopButton.bmp");
		assert(StopButton.GetStatus()==BitMapOkay);
		ExitButton.Load("ExitButton.bmp");
		assert(ExitButton.GetStatus()==BitMapOkay);
		
		Position P1 = W.GetCenter()+Position(-2-0.5*StartButton.GetWidth(),2);
		StartButton.SetPosition(P1); 
		Position P2 =W.GetCenter()+Position(0-0.5*StartButton.GetWidth(),2);
		StopButton.SetPosition(P2); 
		Position P3 =W.GetCenter()+Position(+2-0.5*StartButton.GetWidth(),2);
		ExitButton.SetPosition(P3); 

		Wizard[1].Draw();
		StartButton.Draw();
		StopButton.Draw();
		ExitButton.Draw();
		
	}


	// Gestione dei bottoni
	int MouseEvent(const Position &P){
		// se StopButton ferrma l' animazione
			if (StopButton.IsInside(P)) {
				if (TimerRunning) {
					W.StopTimer();
					TimerRunning=false;
				}
			return 1;
			}
			// se StartButton fai partire l' animazione
			else if (StartButton.IsInside(P)) {
				if (!TimerRunning){
					W.StartTimer(400);
					TimerRunning=true;
				}
				return 1;
			}
			// se ExitButton esci chiamando ApiEnd()
			else if (ExitButton.IsInside(P)) {
				ApiEnd();
				return 1;
			}
			else return 0;
	}


	// gestione del timer 
	// ogni colta viene mostrata l' immagine successiva
	int TimerEventHandler() {
		Wizard[currentImage].Erase();
		currentImage= (currentImage+1)%10;
		Wizard[currentImage].Draw();
		return 1;
	
	}

private:
		SimpleWindow &W; // Reference alla window
		vector<BitMap> Wizard;  // Contiene le immagini della sequenza
	    BitMap StartButton;		// Bottoni
		BitMap StopButton;
		BitMap ExitButton;
		bool TimerRunning;     // true = l' animazione e' running
		int currentImage;      // l'immagine attualmente mostrata
};
      

// Window e Animazione devono!!!! essere globali
// altrimenti non si riesce a scrivere i callback

SimpleWindow Win("Animazione",10,10);
Animazione A(Win);


// callback per gli eventi del mouse
// rimanda ad un metodo di animazione
int MouseClickEvent(const Position &P){
	return(A.MouseEvent(P));
}

// callback per il timer
// rimanda ad un metodo di animazione 
int TimerEvent(){
	return(A.TimerEventHandler());
}

ApiMain() { 
	Win.Open();
	// inizializzxa l' animazione
	A.Init(); 
	// callback
	Win.SetMouseClickCallback(MouseClickEvent);
	Win.SetTimerCallback(TimerEvent);	
	return 0;
}      


ApiEnd() {	
	Win.StopTimer(); 
	Win.Close();
	exit(0);  // forza l' uscita del programma 
	// altrimenti il prcesso non termina
	// return 0;
}  