/* grammatica 1.2 */

/* per caricare il sistema GULP - UNIFICAZIONE */
:- consult('/home2/httpd/html/research/HYPERPROLOG/esempi/unificazione/gulp3').


try(X):-write(['grammatica 1.2']),nl,write(X),nl,s(Y,X,[]),g_display(Y),nl,nl.

/* frase con solo il controlo del sing o plur e la categoria sia del soggetto che del verbo*/
s(S)-->np(NP),vp(VP),
              {S=sinta_nominale:NP, 
               S=sinta_verbale:VP,
               NP=num:Num,
	       VP=num:Num,
               NP=cat:Cat,
	       VP=cat_s:Cat1,
               S=cat_s:Cat,
	       S=cat_s:Cat1}.

/* frase con il controlo del sing o plur,del pers e la categoria sia del soggetto che del verbo*/
s(S)-->np(NP),vp(VP),
              {S=sinta_nominale:NP, 
               S=sinta_verbale:VP,
               NP=num:Num,
	       VP=num:Num,
               NP=pers:Pers,
	       VP=pers:Pers,
               NP=cat:Cat,
	       VP=cat_s:Cat1,
               S=cat_P:Cat,
	       S=cat_P:Cat1}.

/* s_nominale con articolo e nome */
np(NP)-->det(D),n(N),
         {NP=art:D,
          NP=nome:N,
	  D=gen:Gen,
          N=gen:Gen,
          D=num:Num,
          N=num:Num,
          NP=num:Num,
          N=cat:Cat,
          NP=cat:Cat}.

/* s_nominale con pronome */  
np(NP)-->det(D),n_pr(N),
         {NP=ac:D,
          NP=prn_nome:N,
	  D=gen:Gen,
          N=gen:Gen,
          D=num:Num,
          N=num:Num,
          NP=num:Num,
          N=cat:Cat,
          NP=cat:Cat}.

/* s_nominale con nome proprio */
np(NP)-->det(D),pr(N),
         {NP=ac:D,
          NP=pr_nom:N,
	  D=gen:Gen,
          N=gen:Gen,
          D=num:Num,
          N=num:Num,
          NP=num:Num,
          N=cat:Cat,
          NP=cat:Cat}.

/* s_nominale con pronome */          
np(NP)-->pr(PR),
         {NP=pronome:PR,
          PR=pers:Pers,
          NP=pers:Pers,
          PR=num:Num,
          NP=num:Num,
	  PR=cat:Cat,
          NP=cat:Cat}.

/* s_nominale con nome proprio */
np(NP)-->n_pr(PR),
         {NP=nome_pro:PR,
          PR=pers:Pers,
          NP=pers:Pers,
          PR=num:Num,
          NP=num:Num,
	  PR=cat:Cat,
          NP=cat:Cat}.

/* s_verbale intransitivo */
vp(VP)-->v(V),
            {VP=verb:V,
             V=num:Num,
             VP=num:Num,
             V=pers:Pers,
             VP=pers:Pers,
             VP=cat_s:Cat1,
             V=syn:intr,
             V=cat1:Cat1}.

/* s_verbale transitivo con controllo di categoria tra verbo e oggetto */
vp(VP)-->v(V),np(NP),
            {VP=verb:V,
	     VP=ogg:NP,
             VP=cat_s:Cat1,             
             VP=cat_o:Cat2,
             VP=cat_o:Cat,
             V=num:Num,
             VP=num:Num,
	     V=syn:tr,
             V=pers:Pers,             
             VP=pers:Pers,
             NP=cat:Cat,
	     V=cat2:Cat2,
             V=cat1:Cat1}.

/* nome */
n(N)-->[X],{nome(X,Num,Gen,Cat),N=nom:X..gen:Gen..num:Num..cat:Cat}.

/* articolo determinativo */
det(D)-->[X], {art(X,Gen,Num),D=det:X..num:Num..gen:Gen}.  

/* ausiliare a */
det(D)-->[X], {a_c(X,Gen,Num),D=acc:X..num:Num..gen:Gen}.

/* pronome */
pr(PR)-->[P],{prnome(P,Num,Pers,Cat),PR=prn:P..num:Num..pers:Pers..cat:Cat}.

/* nome proprio */
n_pr(PR)-->[P],{nome_pr(P,Num,Pers,Cat),PR=n_prp:P..num:Num..pers:Pers..cat:Cat}.

/* verbo transi */
v(V)-->[X],{verbo(X,Tr,Pers,Num,Cat1,Cat2),V=ver:X..syn:Tr..pers:Pers..num:Num..cat1:Cat1..cat2:Cat2}.     

/* verbo intrans */
v(V)-->[X],{verbo(X,Tr,Pers,Num,Cat1),V=ver:X..syn:Tr..pers:Pers..num:Num..cat1:Cat1}.



nome(ragazzo,sing,mas,umano).
nome(ragazzi,plur,mas,umano).
nome(ragazza,sing,fem,umano).
nome(ragazze,plur,fem,umano).
nome(mela,sing,fem,commestibile).
nome(mele,plur,fem,commestibile).
nome(gelato,sing,mas,commestibile).
nome(gelati,plur,mas,commestibile).
nome(chiodo,sing,mas,piantabile).
nome(chiodi,plur,mas,piantabile).
nome(seme,sing,mas,piantabile).
nome(semi,plur,mas,piantabile).
nome(martello,sing,mas,utensile).
nome(martelli,plur,mas,utensile).


prnome(io,sing,'1per',umano).
prnome(me,sing,'1per',umano).
prnome(tu,sing,'2per',umano).
prnome(te,sing,'2per',umano).
prnome(egli,sing,'3per',umano).
prnome(lui,sing,'3per',umano).
prnome(lei,sing,'3per',umano).
prnome(noi,plur,'1per',umano).
prnome(voi,plur,'2per',umano).
prnome(loro,plur,'3per',umano).


nome_pr(marco,sing,'3per',umano).
nome_pr(laura,sing,'3per',umano).


verbo(parla,tr,'3per',sing,umano,umano).
verbo(parlo,tr,'1per',sing,umano,umano).
verbo(mangia,tr,'3per',sing,umano,commestibile).
verbo(mangiano,tr,'3per',plur,umano,commestibile).
verbo(mangio,tr,'1per',sing,umano,commestibile).
verbo(pianto,tr,'1per',sing,umano,piantabile).
verbo(pianta,tr,'3per',sing,umano,piantabile).
verbo(piantiamo,tr,'1per',plur,umano,piantabile).
verbo(pianta,tr,'3per',sing,utensile,piantabile).
verbo(piantano,tr,'1per',plur,utensile,piantabile).
verbo(usa,tr,'3per',sing,umano,utensile).
verbo(parlo,intr,'1per',sing,umano).
verbo(parla,intr,'3per',sing,umano).
verbo(pianta,intr,'3per',sing,umano).
verbo(pianto,intr,'1per',sing,umano).
verbo(piantano,intr,'3per',plur,umano).
verbo(mangia,intr,'3per',sing,umano).
verbo(mangiano,intr,'3per',plur,umano).
verbo(mangio,intr,'1per',sing,umano).
verbo(corre,intr,'3per',sing,umano).
verbo(corrono,intr,'3per',plur,umano).
verbo(corro,intr,'1per',sing,umano).


art(i,mas,plur).
art(il,mas,sing).
art(la,fem,sing).
art(le,fem,plur).

a_c(a,mas,sing).
a_c(a,mas,plur).
a_c(a,fem,sing).
a_c(a,fem,plur).


p1 :- try([il,ragazzo,mangia]).
p2 :- try([la,ragazza,mangia]).
p3 :- try([i,ragazzi,mangiano]).
p4 :- try([i,ragazzi,mangia]).
p5 :- try([le,ragazze,mangia]).
p6 :- try([le,ragazze,mangiano]).
p7 :- try([la,ragazze,mangiano]).
p8 :- try([la,ragazza,mangia,il,gelato]).
p9 :- try([le,ragazze,mangiano,i,gelati]).
p10 :- try([il,ragazzo,mangia,i,gelati]).
p11 :- try([il,ragazzo,corre]).
p12 :- try([loro,corrono]).
p13 :- try([egli,corrono]).
p14 :- try([egli,corre]).
p15 :- try([loro,mangiano,il,gelato]).
p16 :- try([loro,mangiano,i,gelati]).
p17 :- try([marco,parla,a,laura]).
p18 :- try([loro,mangiano,il,gelati]).
p19 :- try([laura,mangia,il,gelato]).
p20 :- try([io,parlo,a,loro]).
p21 :- try([io,mangio,i,gelati]).
p22 :- try([il,gelato,mangia,il,ragazzo]).
p23 :- try([il,gelato,corre]).
p24 :- try([marco,mangia]).
p25 :- try([io,mangio,il,chiodo]).
p26 :- try([io,pianto,il,chiodo]).
p27 :- try([il,chiodo,mangia,il,gelato]).
p28 :- try([il,gelato,pianta,il,ragazzo]).
p29 :- try([il,ragazzo,pianta,il,chiodo]).
p30 :- try([il,ragazzo,pianta,la,mela]).
p31 :- try([il,ragazzo,pianta,la,mela]).
p32 :- try([il,ragazzo,pianta,i,semi]).
p33 :- try([il,seme,mangia,la,mela]).
p34 :- try([il,martello,pianta,i,chiodi]).
p35 :- try([i,martelli,piantano,il,chiodo]).
p36 :- try([il,ragazzo,pianta,il,martello]).
p37 :- try([il,martello,pianta,il,ragazzo]).
p38 :- try([il,ragazzo,usa,il,martello]).
p39 :- try([il,martello,usa,il,ragazzo]).




