/* grammatica 1.1 */

/* per caricare il sistema GULP - UNIFICAZIONE */
:- consult('/home2/httpd/html/research/HYPERPROLOG/esempi/unificazione/gulp3').


try(X):-write(['grammatica 1.1']),nl,write(X),nl,s(Y,X,[]),g_display(Y),nl,nl.

/* frase con solo il controlo del sing o plur */
s(S)-->np(NP),vp(VP),
              {S=sinta_nominale:NP, 
               S=sinta_verbale:VP,
               NP=num:Num,
	       VP=num:Num}.

/* frase con il controlo del sing o plur e del pers */
s(S)-->np(NP),vp(VP),
              {S=sinta_nominale:NP, 
               S=sinta_verbale:VP,
               NP=num:Num,
	       VP=num:Num,
               NP=pers:Pers,
	       VP=pers:Pers}.

/* s_nominale con articolo e nome */
np(NP)-->det(D),n(N),
         {NP=art:D,
          NP=nome:N,
	  D=gen:Gen,
          N=gen:Gen,
          D=num:Num,
          N=num:Num,
          NP=num:Num}.

/* s_nominale con pronome */        
np(NP)-->pr(PR),
         {NP=pronome:PR,
          PR=pers:Pers,
          NP=pers:Pers,
          PR=num:Num,
          NP=num:Num}.

/* s_nominale con nome proprio */
np(NP)-->n_pr(PR),
         {NP=nome_pro:PR,
          PR=pers:Pers,
          NP=pers:Pers,
          PR=num:Num,
          NP=num:Num}.

/* s_verbale intransitivo */
vp(VP)-->v(V),
            {VP=verb:V,
             V=num:Num,
             VP=num:Num,
             V=pers:Pers,
             VP=pers:Pers,
             V=syn:intr}.

/* s_verbale transitivo */
vp(VP)-->v(V),np(NP),
            {VP=verb:V,
	     VP=ogg:NP,
             V=num:Num,
             VP=num:Num,
	     V=syn:tr,
             V=pers:Pers,             
             VP=pers:Pers}.
   
/* nome */
n(N)-->[X],{nome(X,Num,Gen),N=nom:X..gen:Gen..num:Num}.

/* articolo determinativo */
det(D)-->[X], {art(X,Gen,Num),D=det:X..num:Num..gen:Gen}.  

/* pronome */
pr(PR)-->[P],{prnome(P,Num,Pers),PR=prn:P..num:Num..pers:Pers}.

/* nome proprio */
n_pr(PR)-->[P],{nome_pr(P,Num,Pers),PR=n_prp:P..num:Num..pers:Pers}.

/* verbo */
v(V)-->[X],{verbo(X,Tr,Pers,Num),V=ver:X..syn:Tr..pers:Pers..num:Num}.     



nome(ragazzo,sing,mas).
nome(ragazzi,plur,mas).
nome(ragazza,sing,fem).
nome(ragazze,plur,fem).
nome(mela,sing,fem).
nome(mele,plur,fem).
nome(gelato,sing,mas).
nome(gelati,plur,mas).


prnome(io,sing,'1per').
prnome(tu,sing,'2per').
prnome(egli,sing,'3per').
prnome(noi,plur,'1per').
prnome(voi,plur,'2per').
prnome(loro,plur,'3per').


nome_pr(marco,sing,'3per').
nome_pr(laura,sing,'3per').


verbo(mangia,tr,'3per',sing).
verbo(mangiano,tr,'3per',plur).
verbo(mangio,tr,'1per',sing).
verbo(mangia,intr,'3per',sing).
verbo(mangiano,intr,'3per',plur).
verbo(mangio,intr,'1per',sing).
verbo(corre,intr,'3per',sing).
verbo(corrono,intr,'3per',plur).
verbo(corro,intr,'1per',sing).


art(i,mas,plur).
art(il,mas,sing).
art(la,fem,sing).
art(le,fem,plur).



p1 :- try([il,ragazzo,mangia]).
p2 :- try([la,ragazza,mangia]).
p3 :- try([i,ragazzi,mangiano]).
p4 :- try([i,ragazzi,mangia]).
p5 :- try([le,ragazze,mangia]).
p6 :- try([le,ragazze,mangiano]).
p7 :- try([la,ragazze,mangiano]).
p8 :- try([la,ragazza,mangia,il,gelato]).
p9 :- try([le,ragazze,mangiano,i,gelati]).
p10 :- try([il,ragazzo,mangia,i,gelati]).
p11 :- try([il,ragazzo,corre]).
p12 :- try([loro,corrono]).
p13 :- try([egli,corrono]).
p14 :- try([egli,corre]).
p15 :- try([loro,mangiano,il,gelato]).
p16 :- try([loro,mangiano,i,gelati]).
p18 :- try([loro,mangiano,il,gelati]).
p19 :- try([io,mangio,il,gelato]).
p20 :- try([io,corro]).
p21 :- try([io,mangio,i,gelati]).
p22 :- try([il,gelato,mangia,il,ragazzo]).
p23 :- try([il,gelato,corre]).
p24 :- try([marco,mangia]).
