% file predefiniti/filetto.pl

% gioco del filetto

/* rappresentazione della scacchiera:

     s(x1,x2,x3,x4,x5,x6,x7,x8,x9)

dove xi puo' essere 'x' 'o' o una variabile
gli argomenti corrispondono a queste
 posizioni sulla scacchiera

      1 2 3
      4 5 6 
      6 7 8

esempio di uso:

?- inizio.
?- mossa(x,3).
?- mossa(0,2).
?- mossa(x,5).
?- minaccia(X,Y).
......
......

*/

% inizio crea una scacchiera vuota 
% e la asserisce nel database
inizio :-
  retract(scacchiera(_)), % c'e' gia_ una scacchiera
  functor(T,s,9),  % T e' una scacchiera vuota 
  mostra(T),
  assert(scacchiera(T)).
inizio :-
  functor(T,s,9),  % T e' una scacchiera vuota 
  mostra(T),
  assert(scacchiera(T)).

% gestisce una mossa
% si mette Pezzo che puo' essere '0' o 'x'
% in Pos

mossa(Pezzo,Pos) :-
  scacchiera(Scac),  % configurazione memorizzata
  vuoto(Pos,Scac),   % la posizione deve essere libera
  retract(scacchiera(Scac)),  % elimina vecchia configurazione
  arg(Pos,Scac,Pezzo),        % istanzia l'argomento
  assert(scacchiera(Scac)),   % memorizza nuova configurazione 
  mostra(Scac),               % visualizza 
  (vince(Scac,Giocatore),     % controlla se mossa vincente
   write(Giocatore),
   write(' ha vinto!'),
   nl;                        % ';' significa OR
   true).  

% la posizione Pos in Scac e' vuota 
vuoto(Pos,Scac) :-
  arg(Pos,Scac,Val), var(Val).
% la posizione Pos in Scac e' 'x'
croce(Pos,Scac) :-
  arg(Pos,Scac,Val), nonvar(Val),Val=x.
% la posizione Pos in Scac e' '0'
zero(Pos,Scac) :-
  arg(Pos,Scac,Val), nonvar(Val),Val=0. 


% visualizzazione della scacchiera
 
riga([1,2,3]).
riga([4,5,6]).
riga([7,8,9]).


mostra(Scac) :-
    riga([Pos1,Pos2,Pos3]),
    mostra_pos(Pos1,Scac), tab(2),
    mostra_pos(Pos2,Scac), tab(2),
    mostra_pos(Pos3,Scac), tab(2),
    tab(5),write([Pos1,Pos2,Pos3]),
    nl,nl,
    fail.
mostra(_). 

mostra_pos(Pos,Scac):-
  vuoto(Pos,Scac),
  write('-').
mostra_pos(Pos,Scac):-
  croce(Pos,Scac),
  write(x).
mostra_pos(Pos,Scac):-
  zero(Pos,Scac),
  write(0).

 
% tabella delle posizioni allineate

allineate([1,2,3]).  % righe
allineate([4,5,6]).
allineate([7,8,9]).
allineate([1,4,7]).  % colonne
allineate([2,5,8]).
allineate([3,6,9]).
allineate([1,5,9]).  % diagonali
allineate([3,5,7]).

% croce vince
vince(Scac,croce) :-
  allineate([Pos1,Pos2,Pos3]),
  croce(Pos1,Scac),
  croce(Pos2,Scac),
  croce(Pos3,Scac).

% zero vince
vince(Scac,zero) :- 
  allineate([Pos1,Pos2,Pos3]),
  zero(Pos1,Scac),
  zero(Pos2,Scac),
  zero(Pos3,Scac).

% Giocatore minaccia Pos
% C'e' una posizione in cui completa la linea
minaccia(Giocatore,Pos) :-
  scacchiera(Scac),
  allineate(Posizioni),
  controlla(Giocatore,Pos,Posizioni,Scac).

% controlla che ci siano 2 croci e 
% una posizione vuota su una linea
controlla(croce,P1,[P1,P2,P3],Scac) :-
  vuoto(P1,Scac),croce(P2,Scac),croce(P3,Scac).
controlla(croce,P2,[P1,P2,P3],Scac) :-
  croce(P1,Scac),vuoto(P2,Scac),croce(P3,Scac).
controlla(croce,P3,[P1,P2,P3],Scac) :-
  croce(P1,Scac),croce(P2,Scac),vuoto(P3,Scac).

% controlla che ci siano 2 zeri e 
% una posizione vuota su una linea
controlla(zero,P1,[P1,P2,P3],Scac) :-
  vuoto(P1,Scac),zero(P2,Scac),zero(P3,Scac).
controlla(zero,P2,[P1,P2,P3],Scac) :-
  zero(P1,Scac),vuoto(P2,Scac),zero(P3,Scac).
controlla(zero,P3,[P1,P2,P3],Scac) :-
  zero(P1,Scac),zero(P2,Scac),vuoto(P3,Scac).
