%file: predefiniti/contaatomi.pl

%conta gli atomi in una lista

% lista vuota 0 atomi
conta1(_,[],0).
% Atomo e testa della lista coincidono
% conta l' atomo e fa una ricorsione
conta1(Atomo,[Atomo|Resto],N):-
  !,  
  conta1(Atomo,Resto,N1),
  N is N1 + 1.
% Atomo e testa della lista non coincidono
% fai la ricorsione senza contare
conta1(Atomo,[_|Resto],N):-
  conta1(Atomo,Resto,N).

% ?- conta1(a,[a,b,c,a,b])
% ?- conta1(a,[a,X,Y,a,Z])

conta2(_,[],0).
conta2(Atomo,[Primo|Resto],N):-
% Primo e' un atomo, fallisce altrimenti
  atom(Primo),
% Primo concide con Atomo, contalo!
  Primo=Atomo, 
  !,
  conta2(Atomo,Resto,N1),
  N is N1 + 1.
conta2(Atomo,[_|Resto],N):-
  conta2(Atomo,Resto,N).

% ?- conta2(a,[a,b,c,a,b])
% ?- conta2(a,[a,X,Y,a,Z])

