/* file: analisi_9.pl 
   la seguente grammatica tiene conto delleconcordanze in numero 
   e costruisce l'albero sintattico */

/* regole della grammatica */ 
proposizione(Alb) --> proposizione(Alb,_Num).
proposizione(frase(T1,T2),Num) --> sn(T1,Num),sv(T2,Num).
sn(sn(T1,T2),Num) --> articolo(T1,Num),sostantivo(T2,Num).
sv(sv(T1,T2),Num) --> verbo(T1,Num),sn(T2,_N).


/* simboli terminali */
articolo(art(il),sing) --> [il].
articolo(art(i),plur) --> [i].
sostantivo(nome(X),Num) --> [X],{isa_nome(X,Num)}.
verbo(v(X),Num) --> [X],{isa_verbo(X,Num)}.

/* lessico: nomi */
isa_nome(topo,sing).
isa_nome(topi,plur).
isa_nome(gatto,sing).
isa_nome(gatti,plur).

/* lessico: verbi */
isa_verbo(mangia,sing).
isa_verbo(mangiano,plur).

/* goal di prova */

/* sono accettabili queste frasi 
   (e il Prolog dovrebbe risponde YES) */
% ?- proposizione(Alb,[il,gatto,mangia,il,topo],[]).
% ?- proposizione(Alb,[i,gatti,mangiano,il,topo],[]).
% ?- proposizione(Alb,[il,gatto,mangia,i,topi],[]).

/* ma non lo sono queste 
   (e il Prolog dovrebbe risponde NO) */
% ?- proposizione(Alb,[il,gatto,mangiano,il,topo],[]).
% ?- proposizione(Alb,[i,gatti,mangia,il,topo],[]).
% ?- proposizione(Alb,[il,gatto,mangia,il,topi],[]).


