/*    casa.pl  */

/* Esempio di uso del klone */

* per caricare l'ambiente KLONE */

:- consult('/home2/httpd/html/research/HYPERPROLOG/esempi/klone/klone').

casa:-
        

/* definizione delle casa come concetto */
	assume(generic_concept(casa)),
	assume(generic_concept(cosa)),

	

/* la casa e' sussunta da cosa */
	assume(has_super_concept(casa,cosa)),

/*  definizione dei ruoli nella casa */ 

	add(casa,soggiorno,generic_role),
	add(casa,bagno,generic_role),
	add(casa,cucina,generic_role),
	add(casa,ripostiglio,generic_role),
	add(casa,ingresso,generic_role),
	add(casa,camera,generic_role),


/* il filler del ruolo deve appartenere ad un certo ruolo generico 
     value/restriction     */

	assume(has_vr(camera,casa,stanza)),
	assume(has_vr(servizi,casa,servizio)),
	assume(has_vr(soggiorno,casa,stanza)),
	assume(has_vr(ingresso,casa,stanza)),


 /* fissa il numero di possibili fillers dei ruoli */
	assume(has_number(camera,casa,[1,3])),
	assume(has_number(bagno,casa,[1,2])),
	assume(has_number(cucina,casa,[1,1])),
	assume(has_number(ripostiglio,casa,[0,2])),
	assume(has_number(ingresso,casa,[0,1])),
	assume(has_number(soggiorno,casa,[0,1])),

/* in una casa il bagno deve esserci come la cucina e almeno un'altra stanza*/

	assume(has_modality(cucina,casa,obl)),
	assume(has_modality(camera,casa,obl)),
	assume(has_modality(bagno,casa,obl)).

palazzo:-

/*palazzo e' un insieme di case*/
    	assume(generic_concept(palazzo)),

	add(palazzo,appartamenti,generic_role),

	assume(has_vr(appartamenti,palazzo,casa)),

	assume(has_number(appartamenti,palazzo,[1,20])),

	assume(has_modality(appartamenti,palazzo,obl)).

/*   villetta  e' un palazzo formato da un solo appartamento  */
villetta:-

    	assume(generic_concept(villetta)),

	assume(has_super_concept(villetta,palazzo)),

	assume(has_number(appartamenti,villetta,[1,1])),


	assume(has_modality(ingresso,villetta,obl)),
	assume(has_modality(soggiorno,villetta,obl)).


/*     villa e' una villetta con almeno tre camere  e doppi servizi */
villa:-

    	assume(generic_concept(villa)),

	assume(has_super_concept(villa,villetta)),

	assume(has_number(camera,villa,[3,nil])),

	assume(has_number(bagno,villa,[2,nil])).

/*  mini_app e' una casa con un bagno un soggiorno
                  una camera da letto e cucina */
miniapp:-
 
    	assume(generic_concept(miniapp)),

	assume(has_super_concept(miniapp,casa)),

	assume(has_number(camera,miniapp,[1,1])),
	assume(has_number(ingresso,miniapp,[0,0])),
	assume(has_number(bagno,miniapp,[1,1])),
	assume(has_number(ripostiglio,miniapp,[0,0])).


/*concetti individuali*/
/* descrivo le stanze di una particolare casa*/
stanze_di_casa1:-

% stanze possibili di una casa
  assume(generic_concept(stanze_casa)),
  assume(has_super_concept(stanze_casa,stanze)),


% camera_bimbo
	assume(individual_concept(camera_bimbo)),
	assume(individuates(camera_bimbo,stanze_casa)),


% camera_genitori
	assume(individual_concept(camera_genitori)),
	assume(individuates(camera_genitori,stanze_casa)),

% salotto
	assume(individual_concept(salotto)),
	assume(individuates(salotto,stanze_casa)),

% bagno_di_casa
	assume(individual_concept(bagno_di_casa)),
	assume(individuates(bagno_di_casa,stanze_casa)),

% bagno_piccolo
	assume(individual_concept(bagno_piccolo)),

	assume(individuates(bagno_piccolo,stanze_casa)),
% cucinino
	assume(individual_concept(cucinino)),
	assume(individuates(cucinino,stanze_casa)).

%una particolare casa
	assume(individual_concept(casa1)),
	assume(individuates(casa1,casa)).
/* descrivo la casa particolare*/
casa1:-

% PARTICULAR ROLE SET

% questa casa deve essere formata dalle stanze sopra elencate 
  assume(has_vr(stanze,casa1,stanze_casa)),

% INSTANCE ROLES

%camera1 
	add(casa1,camera1,instance_role),
  	assume(satisfies(camera1,casa1,camera,casa)),
	assume(has_value(camera1,casa1,camera_genitori)),
%camera2 
	add(casa1,camera2,instance_role),
  	assume(satisfies(camera2,casa1,camera,casa)),
	assume(has_value(camera2,casa1,camera_bimbo)),

%cucina1
	add(casa1,cucina1,instance_role),
  	assume(satisfies(cucina1,casa1,cucina,casa)),
	assume(has_value(cucina1,casa1,cucinino)),

%salotto1
	add(casa1,salotto1,instance_role),
	assume(satisfies(salotto1,casa1,soggiorno,casa)),
	assume(has_value(salotto1,casa1,salotto)),
%bagno1
	add(casa1,bagno1,instance_role),
  	assume(satisfies(bagno1,casa1,bagno,casa)),
	assume(has_value(bagno1,casa1,bagno_piccolo)),
%bagno2
	add(casa1,bagno2,instance_role),
  	assume(satisfies(bagno2,casa1,bagno,casa)),
	assume(has_value(bagno2,casa1,bagno_di_casa)).

/* descrivo le stanze di una particolare villa*/
stanze_di_villa1:-

% stanze possibili di una casa
  assume(generic_concept(stanze_villa)),
  assume(has_super_concept(stanze_villa,stanze)),

% ingresso_villa
	assume(individual_concept(ingresso_villa)),
	assume(individuates(ingresso_villa,stanze_villa)),

% camera_bimbo1
	assume(individual_concept(camera_bimbo1)),
	assume(individuates(camera_bimbo1,stanze_villa)),

% camera_bimbo2
	assume(individual_concept(camera_bimbo2)),
	assume(individuates(camera_bimbo2,stanze_villa)),


% camera_genitori
	assume(individual_concept(camera_genitori)),
	assume(individuates(camera_genitori,stanze_villa)),


% camera_ospiti
	assume(individual_concept(camera_ospiti)),
	assume(individuates(camera_ospiti,stanze_villa)),

% camera_studio
	assume(individual_concept(camera_studio)),
	assume(individuates(camera_studio,stanze_villa)),

% soggiorno_villa
	assume(individual_concept(soggiorno_villa)),
	assume(individuates(soggiorno_villa,stanze_villa)),

% salotto
	assume(individual_concept(salotto)),
	assume(individuates(salotto,stanze_villa)),

% bagno_villa1
	assume(individual_concept(bagno_villa1)),
	assume(individuates(bagno_villa1,stanze_villa)),

% bagno_villa2
	assume(individual_concept(bagno_villa2)),
	assume(individuates(bagno_villa2,stanze_villa)),

% bagno_piccolo
	assume(individual_concept(bagno_piccolo)),
	assume(individuates(bagno_piccolo,stanze_villa)),
% cucina_villa
	assume(individual_concept(cucina_villa)),
	assume(individuates(cucina_villa,stanze_villa)),

%una particolare villa
	assume(individual_concept(villa1)),
	assume(individuates(villa1,villa)).

/* descrivo la villa particolare*/

villa1:-

% PARTICULAR ROLE SET

% questa casa deve essere formata dalle stanze sopra elencate 
  assume(has_vr(stanze,villa1,stanze_villa)),

% INSTANCE ROLES

%ingresso1 
	add(villa1,ingresso1,instance_role),
  	assume(satisfies(ingresso1,villa1,ingresso,villa)),
	assume(has_value(ingresso1,villa1,ingresso_villa)),

%camera1 
	add(villa1,camera1,instance_role),
  	assume(satisfies(camera1,villa1,camera,villa)),
	assume(has_value(camera1,villa1,camera_genitori)),
%camera2 
	add(villa1,camera2,instance_role),
  	assume(satisfies(camera2,villa1,camera,villa)),
	assume(has_value(camera2,villa1,camera_bimbo1)),

%camera3 
	add(villa1,camera3,instance_role),
  	assume(satisfies(camera3,villa1,camera,villa)),
	assume(has_value(camera3,villa1,camera_bimbo2)),

%camera4 
	add(villa1,camera4,instance_role),
  	assume(satisfies(camera4,villa1,camera,villa)),
	assume(has_value(camera4,villa1,camera_ospiti)),

%camera5 
	add(villa1,camera5,instance_role),
  	assume(satisfies(camera5,villa1,camera,villa)),
	assume(has_value(camera5,villa1,camera_studio)),
%camera6 
	add(villa1,camera6,instance_role),
  	assume(satisfies(camera6,villa1,camera,villa)),
	assume(has_value(camera6,villa1,salotto)),
%cucina1
	add(villa1,cucina1,instance_role),
  	assume(satisfies(cucina1,villa1,cucina,villa)),
	assume(has_value(cucina1,villa1,cucina_villa)),

%soggiorno1
	add(villa1,soggiorno1,instance_role),
	assume(satisfies(soggiorno1,villa1,soggiorno,villa)),
	assume(has_value(soggiorno1,villa1,soggiorno_villa)),
%bagno1
	add(villa1,bagno1,instance_role),
  	assume(satisfies(bagno1,villa1,bagno,villa)),
	assume(has_value(bagno1,villa1,bagno_villa1)),
%bagno2
	add(villa1,bagno2,instance_role),
  	assume(satisfies(bagno2,villa1,bagno,villa)),
	assume(has_value(bagno2,villa1,bagno_villa2)),
%bagno3
	add(villa1,bagno3,instance_role),
  	assume(satisfies(bagno3,villa1,bagno,villa)),
	assume(has_value(bagno3,villa1,bagno_piccolo)).

/*descrivo un mini appartamento particolare*/

stanze_mini_app:-

% stanze possibili di una casa
  	assume(generic_concept(stanze_miniapp)),
  	assume(has_super_concept(stanze_miniapp,stanze)),

% camera_mini
	assume(individual_concept(camera_mini)),
	assume(individuates(camera_mini,stanze_miniapp)),

% soggiorno_mini
	assume(individual_concept(soggiorno_mini)),
	assume(individuates(soggiorno_mini,stanze_miniapp)),

% bagno_mini
	assume(individual_concept(bagno_mini)),
	assume(individuates(bagno_mini,stanze_miniapp)),

% cucinino_mini
	assume(individual_concept(cucinino_mini)),
	assume(individuates(cucinino_mini,stanze_miniapp)).

%un particolare mini appartamento
	assume(individual_concept(mini1)),
	assume(individuates(mini1,miniapp)).



mini1:-



%camera1
	add(mini1,camera1,instance_role),
  	assume(satisfies(camera1,mini1,camera,miniapp)),
	assume(has_value(camera1,mini1,camera_mini)),

%cucina1
	add(mini1,cucina1,instance_role),
  	assume(satisfies(cucina1,mini1,cucina,miniapp)),
	assume(has_value(cucina1,mini1,cucinino_mini)),

%soggiorno1
	add(mini1,soggiorno1,instance_role),
	assume(satisfies(soggiorno1,mini1,soggiorno,miniapp)),
	assume(has_value(soggiorno1,mini1,soggiorno_mini)),
%bagno1
	add(mini1,bagno1,instance_role),
  	assume(satisfies(bagno1,mini1,bagno,miniapp)),
	assume(has_value(bagno1,mini1,bagno_mini)).


palazzo1:-

%un particolare palazzo
	assume(individual_concept(palazzo1)),
	assume(individuates(palazzo1,palazzo)),



%appartamento1 
	add(palazzo1,appartamento1,instance_role),
  	assume(satisfies(appartamento1,palazzo1,appartamenti,palazzo)),
	assume(has_value(appartamento1,palazzo1,casa1)),

%appartamento2 
	add(palazzo1,appartamento2,instance_role),
  	assume(satisfies(appartamento2,palazzo1,appartamenti,palazzo)),
	assume(has_value(appartamento2,palazzo1,mini1)).


inizializza:-
	casa,
	palazzo,
	villetta,
	villa,
	miniapp,
	stanze_di_casa1,
	casa1,
	stanze_di_villa1,
	villa1,
	stanze_mini_app,
	mini1,
	palazzo1.

pp(I_conc) :-
            individual_concept(I_conc),
            write(I_conc),write(' e_ un concetto individiale'),nl,
            individuates(I_conc,G_conc), !,
            write(I_conc),write(' e_ un '),write(G_conc),nl,
            stampa_ruoli(I_conc,G_conc).


pretty_print1(A) :-
   generic_concept(A),
   print_header(g_conc,A),
   print_section(super_c,A,nonfullview),
   print_section(roles,A,fullview),
   skip_line(1).

stampa(I_conc):-
	     casa1, 
	     villa1,
             mini1,
	     palazzo1, 
             has_role(I_conc,I_role),
             write(I_role),write(' e_ un instance_role '),nl, 
             satisfies(I_role,I_conc,G_role,G_conc),
             write(' che individua '),write(G_role),
             stampa_valore(I_role,I_conc,Value),
             fail.

stampa_valore(Ir,Ic,V):- has_value(Ir,Ic,V),
                         write(' come '),write(V),nl,!.
stampa_valore(Ir,Ic,V):- write(' non ha nessun tipo '),nl,!.

