% file: cut/insiemi2.pl

% versione di intersezione e unione che usano "not"
% al posto del "cut"
  
appartiene(X,[X|_]) :- !.
appartiene(X,[_|Y]) :- appartiene(X,Y).

incluso([],_).
incluso([X|C],Y) :-
  appartiene(X,Y),
  incluso(C,Y). 

intersezione([],_Y,[]).
intersezione([X|R],Y,[X|Z]) :-
  appartiene(X,Y),
  intersezione(R,Y,Z).
intersezione([X|R],Y,Z) :- 
  \+ appartiene(X,Y),
  intersezione(R,Y,Z).

unione([],X,X).
unione([X|C],Y,Z) :- 
  appartiene(X,Y),
  unione(C,Y,Z).
unione([X|C],Y,[X|Z]) :-
  \+ appartiene(X,Y),
  unione(C,Y,Z).

/* provate, forzando il backtraking con "solutions=all",
i goal seguenti:
?- intersezione([4],[4,1],L).
?- unione([4],[4,1],L).
*/
