/* Pitagora - da Casadei e Teolis   */

formula(cateto1, cateto2, ipotenusa, pitagora).
formula(altezza, proiezione1, cateto1, pitagora).
formula(altezza, proiezione2, cateto2, pitagora).
formula(proiezione1, proiezione2, altezza, euclide1).
formula(cateto1, proiezione1, ipotenusa, euclide2).
formula(cateto2, proiezione2, ipotenusa, euclide2).
formula(cateto1, cateto2, area, formula_area_1).
formula(ipotenusa, altezza, area, formula_area_2).
formula(proiezione1, proiezione2, ipotenusa, somma).
formula(cateto1, cateto2, somma_cateti, somma).
formula(somma_cateti, ipotenusa, perimetro, somma).

regola(X,Y,Z,W) :- formula(X,Y,Z,W).
regola(X,Y,Z,W) :- formula(Z,X,Y,W).
regola(X,Y,Z,W) :- formula(Y,Z,X,W).

problema :- input(X,Y,Z),
            una_soluzione(Z,[Z],[X,Y],L,[],R),
            stampa(R),
            continua.
input(X,Y,Z) :- immetti('primo dato ',X),
                immetti('secondo dato ',Y),
                immetti('incognita ',Z),
                !.

immetti(Testo,X) :- repeat,
                    write(Testo),
                    read(X),
                    controlla(X).

controlla(X) :- regola(X,_,_,_).
controlla(X) :- write('dato sbagliato'),nl,!,fail.

una_soluzione(Z,I,L,L,R,R) :- member(Z,L),!.
una_soluzione(Z,I,L,[Z|L0],R,[r(Z,W,X,Y)|R0]) :-
                     regola(Z,X,Y,W),
                     not member(X,I),
                     not member(Y,I),
                     una_soluzione(X,[X|I],L,L1,R,R1),
                     una_soluzione(Y,[Y|I],L1,L0,R1,R0).

member(X,[X|_]) :- !.
member(X,[_|Y]) :- member(X,Y).

stampa(R) :- nl, write('soluzione:'),
             stampa1(R),!.

stampa1([]).
stampa1([r(Z,W,X,Y)|T]) :- stampa1(T),
                           nl,stampa2(Z,W,X,Y).

stampa2(Z,W,X,Y) :- write('calcolare '), write(Z),
                    write(' applicando '), write(W),
                    write(' a '),write(X), write(' e '),
                    write(Y).

continua :- nl,write('ancora? (s./n.) '),read(s), !, fail.
continua.


