/*       LISTE       */

/* lunghezza di una lista */
lunghezza([],0).
lunghezza([_|X],N) :- lunghezza(X,N1), N is N1+1 .


/* membro di una lista */
membro(X,[X|_]).
membro(X,[_|Y]) :- membro(X,Y).


/* una lista? */
est_lista([]).         /* debole */
est_lista([_|_]).


est_lista2([]).         /* forte  */
est_lista2([_|Tail]) :- est_lista2(Tail).


/* concatena  */
concatena([],L,L).
concatena([H|X],Y,[H|Z]) :- concatena(X,Y,Z).


/* inverti */
inverti([],[]).
inverti([H|T],L) :- inverti(T,Z), concatena(Z,[H],L).


% Esempi:

% Goal(first): membro(c,[a,b,c,d]).
% Risposta:    Yes

% Goal(first): lunghezza([a,b,c,d],X).
% Risposta:    X = 4

% Goal(first): est_lista([a,b,c,d]).
% Risposta:    Yes
% Goal(first): est_lista([a|b]).
% Risposta:    Yes

% Goal(first): est_lista2([a,b,c,d]).
% Risposta:    Yes
% Goal(first): est_lista2([a|b]).
% Risposta:    No

% Goal(first): concatena([a,b],[c,d],X).
% Risposta:    X = [a, b, c, d]

% Goal(first): inverti([a,b,c,d],X).
% Risposta:    X = [d, c, b, a]

