/* Si abbia un labirinto con 7 stanze (a,b,c,d,e,f,g).
   porta(a,b) indica che c'e' una porta tra a e b.
   Il goal vai_da(a,g) con Solutions all produce tutti
   i percorsi possibili tra a e g  */

porta(a,b).
porta(b,e).
porta(b,c).
porta(d,e).
porta(c,d).
porta(e,f).
porta(g,e).

vai_da(X,X,T) :- inverti(T,P),write(P),nl.
vai_da(X,Y,T) :-
     (porta(X,Z);porta(Z,X)),
     not(membro(Z,T)),
     vai_da(Z,Y,[Z|T]).

vai_da(X,Y) :- vai_da(X,Y,[X]).

membro(X,[X|_]).
membro(X,[_|Y]) :- membro(X,Y).

inverti([],[]).
inverti([H|T],L) :- inverti(T,Z), concatena(Z,[H],L).

concatena([],L,L).
concatena([H|X],Y,[H|Z]) :- concatena(X,Y,Z).


% Esempi:

% Goal(all):   vai_da(a,g).
% Risposta:    [a, b, e, g]
%              [a, b, c, d, e, g]

