% introduzione: fatti, regole e domande. 


% definizione di fatti

 possiede(adriano,ristorante).
 possiede(giovanni,casa).

 fratelli(adriano,paolo).

 in_italia(roma).
 in_italia(genova).
 in_usa(new_york).
 in_usa(los_angeles).

/*
   esempi di domande

 ?-possiede(adriano,casa). % adriano possiede una casa?

 ?-in_italia(roma).  % roma e' in italia? "

 ?-possiede(giovanni,casa).  %"Giovanni possiede una casa? "

 ?-fratelli(adriano,giovanni). % "Adriano e' fratello di Giovanni? "
 
 ?-fratelli(paolo,adriano). % la risposta sara' no
  
 ?-in_usa(new_york).% "New York e' in Usa? "

 ?-in_usa(chicago). % la risposta sara' no!
 
   uso delle variabili nelle domande
 
 ?-possiede(adriano,X). % "cosa possiede adriano? "
 "  
 ?-possiede(carlo,Y).   % la risposta sara' no!  

 ?-fratelli(Y,paolo). % chi e' fratello di paolo? "
 
 ?-in_italia(Z). % "quali citta' ci sono in Italia? "
*/


% domande complesse (congiunzione di obiettivi)

% fatti:

 eta(giovanni,30).
 eta(andrea,20).
 eta(giovanni,32).
 eta(paolo,32).
 eta(anna,25).


/* "Esistono due persone che si chiamano rispettivamente 
 Giovanni e Paolo e che hanno la stessa eta ? "*/

 ?-eta(giovanni,X),eta(paolo,X).


 
 

% fatti:

 sorella(alice,franco).
 sorella(paola,franco).
 sorella(alice,anna).
 sorella(alice,giulia).
 sorella(paola,michela).
 sorella(gianna,paola).

 amiche(paola,giulia).
 amiche(anna,michela).

/* "Esistono due amiche, di cui una ha 
una sorella che si chiama Alice e l'altra
ha una sorella che si chiama Paola? " */

 ?-sorella(alice,X),sorella(paola,Y),amiche(X,Y).



% definizione di regole

% definisce il fatto genitore 
  genitore(pam,tom).
  genitore(tom,bob).
% definisce una regola
  figlio(Y,X) :- genitore(X,Y).

/*
  possibili domande: 
  
  ?- figlio(X,tom).  % "chi e' figlio di tom? "

  ?- figlio(bob,X).  % "di chi e' figlio bob? "

  ?- figlio(X,Y).    % "trova un X e un Y tali che X sia figlio di Y"


% i tesserati
 tesserato(bianchi).
 tesserato(rossi).

% i libri in inventario
 in_schedario(moby_dick).
 in_schedario(la_valle_dell_eden).
 in_schedario(gorki_park).
 
% i prestiti 
 non_in_prestito(moby_dick).
 non_in_prestito(gorky_park).
 

/* Questa regola esprime il concetto cheil signor Y puo' consultare 
il libro X se Y ha la tessera di accesso alla biblioteca, e se il 
libro X inventariato e non gia' stato concesso in prestito ad altri.*/ 


 consulta_libro(Y,X):-tesserato(Y),in_schedario(X),
 non_in_prestito(X).


% ?-consulta_libro(rossi,gorki_park). /* "Rossi puo' consultare
                                          Gorky Park? " */
