% file: backtracking/perc1.pl
% Cerca un percorso che porta da una citta' ad un'altra 
% usando il backtracking del Prolog

% Mappa delle  strade che collegano alcune citta 
/*     
      a -- b -- c
      \    |    |
       \   |    | 
        \  |    |     
         \ |    | 
           d -- e
*/

% le strade
strada(a,d).
strada(a,b).
strada(b,c).
strada(c,e).
strada(d,b).
strada(d,e).


% le citta X e Y sono connesse 
connesso(X,Y) :- 
  strada(X,Y).
connesso(X,Y) :-
  strada(Y,X).

% percorso(X,Y)  
% trova un percorso da X a Y 
% prima versione
percorso(X,Y) :- 
  connesso(X,Y).
percorso(X,Y) :- 
  connesso(X,Z),
  percorso(Z,Y).

% ?- percorso(a,b).
% ?- percorso(a,e).

% percorso(X,Y)  
% trova un percorso da X a Y 
% seconda versione
percorso(X,Y,T) :-
  connesso(X,Y), 
  write([Y|T]),nl.
percorso(X,Y,T) :- 
  connesso(X,Z),
  Z \= Y,
  \+ membro(Z,T),
  percorso(Z,Y,[Z|T]).

% percorso(X,Y)  
% trova un percorso da X a Y 
% terza versione
percorso(X,Y,T,[Y|T]):-
  connesso(X,Y).
percorso(X,Y,T,L) :- 
  connesso(X,Z), 
  Z \= Y,     
  \+ membro(Z,T),
  percorso(Z,Y,[Z|T],L).

membro(X,[X|_]).
 membro(X,[_|Y]) :- membro(X,Y).













