% file: backtracking/perc2.pl
% Cerca un percorso che porta da una citta' ad un'altra 
% usando il backtracking del Prolog

% Mappa delle  strade che collegano alcune citta 
/*     
      a -- b -- c
      \    |    |
       \   |    | 
        \  |    |     
         \ |    | 
           d -- e
*/

% le strade
strada(a,d).
strada(a,b).
strada(b,c).
strada(c,e).
strada(d,b).
strada(d,e).

% le citta X e Y sono connesse 
connesso(X,Y) :- 
  strada(X,Y).
connesso(X,Y) :-
  strada(Y,X).

% percorso(X,Y)  
% trova un percorso da X a Y 
% seconda versione
percorso(X,Y,T) :-
  connesso(X,Y), 
  write([Y|T]),nl.
percorso(X,Y,T) :- 
  connesso(X,Z),
  Z \= Y,
  \+ membro(Z,T),
  percorso(Z,Y,[Z|T]).

% ?- percorso(a,c,[a]).

membro(X,[X|_]).
 membro(X,[_|Y]) :- membro(X,Y).













