% file: backtracking/percorso.pl

/* Mappa delle  strade che collegano alcune citta */
/*     
      a -- b -- c
      \    |    |
       \   |    | 
        \  |    |     
         \ |    | 
           d -- e
           
*/

% le strade
strada(a,b).
strada(b,c).
strada(b,d).
strada(d,e).
strada(c,e).

% le citta X e Y sono connesse 
connesso(X,Y) :- 
  strada(X,Y).
connesso(X,Y) :-
  strada(Y,X).

% percorso(X,Y) -  Trova un percorso da X a Y 
percorso(X,Y) :- 
  connesso(X,Y).
percorso(X,Y) :- 
  connesso(X,Z),
  percorso(Z,Y).

percorso(X,X,T) :- 
  write(T),nl.
percorso(X,Y,T) :- 
  connesso(X,Z),          
  \+ member(Z,T),
  percorso(Z,Y,[Z|T],L).

percorso(X,X,T,T).
percorso(X,Y,T,L) :- 
  connesso(X,Z),          
  \+ member(Z,T),
  percorso(Z,Y,[Z|T],L).

