%file: membrolett.pl
%  membro_letterale(X,L) 
%  controlla se X compare 
%  in modo 'letterale' nella lista L
%  usa il predicato predefinito "=="

membro_letterale(X,[Y|_]):-
  X==Y.
membro_letterale(X,[_|C]) :-
  membro_letterale(X,C).

% la definizione usuale di membro
membro(X,[Y|_]) :- X==Y.
membro(X,[_|C]) :- membro(X,C).

% ?- membro(a,[b,c,Z,d,e])
% ?- membro_letterale(a,[b,c,Z,d,e])

% ?- membro_letterale(x,[Y,f(z),X].
% ?- membro_letterale(x,[x,f(x),X].
% ?- membro_letterale(f(x),[x,f(z),X].
% ?- membro_letterale(f(x),[x,f(x),X].
% ?- membro_letterale(f(X),[x,f(Y),X].
% ?- membro_letterale(f(X),[x,f(X),X].
