% file predefiniti/filetto0.pl

% gioco del filetto
/* rappresentazione della scacchiera:

     s(x1,x2,x3,x4,x5,x6,x7,x8,x9)

dove xi puo' essere 'x' 'o' o una variabile
gli argomenti corrispondono a queste
 posizioni sulla scacchiera

      1 2 3
      4 5 6 
      6 7 8

esempio di uso:

?- inizio.
?- mossa(x,3).
?- mossa(0,2).
?- mossa(x,5).
......
......
    
*/


%inizio crea una scacchiera vuota 
%e la asserisce nel database
inizio :-
  functor(T,s,9),  % T e' una scacchiera vuota 
  mostra(T),
  assert(scacchiera(T)).

% gestisce una mossa
% si mette Pezzo che puo' essere '0' o 'x'
% in Pos

mossa(Pezzo,Pos) :-
  scacchiera(Scac),  % configurazione memorizzata
  vuoto(Pos,Scac),   % la posizione deve essere libera
  retract(scacchiera(Scac)),  % elimina vecchia configurazione
  arg(Pos,Scac,Pezzo),        % istanzia l'argomento
  assert(scacchiera(Scac)),   % memorizza nuova configurazione 
  mostra(Scac).               % visualizza 

% la posizione Pos in Scac e' vuota 
vuoto(Pos,Scac) :-
  arg(Pos,Scac,Val), var(Val).
% la posizione Pos in Scac e' 'x'
croce(Pos,Scac) :-
  arg(Pos,Scac,Val), nonvar(Val),Val=x.
% la posizione Pos in Scac e' '0'
zero(Pos,Scac) :-
  arg(Pos,Scac,Val), nonvar(Val),Val=0. 


% visualizzazione della scacchiera
 
riga([1,2,3]).
riga([4,5,6]).
riga([7,8,9]).


mostra(Scac) :-
    riga([Pos1,Pos2,Pos3]),
    mostra_pos(Pos1,Scac), tab(2),
    mostra_pos(Pos2,Scac), tab(2),
    mostra_pos(Pos3,Scac), tab(2),
    tab(5),write([Pos1,Pos2,Pos3]),
    nl,nl,
    fail.
mostra(_). 

mostra_pos(Pos,Scac):-
  vuoto(Pos,Scac),
  write('-').
mostra_pos(Pos,Scac):-
  croce(Pos,Scac),
  write(x).
mostra_pos(Pos,Scac):-
  zero(Pos,Scac),
  write(0).

