% file: liste/es6.pl
% sottoliste

% sublist(S,L) - S e' una sottolista di L

sublist(S,L) :-
  conc(L2,L3,L), % la lista L viene divisa nelle due parti L2 e L3
  conc(L1,S,L2). % la lista L1 viene a sua volta divisa in L1 e S


% concatena due liste 

conc([],L,L).
conc([X|L1],L2,[X|L3]) :- conc(L1,L2,L3).

/*  possibili goal:

% [b,c,d] e' una sottolista di [a,b,c,d,e]
?- sublist([b,c,d],[a,b,c,d,e]).

% trova tutte le sottoliste di [a,b,c,d,e]
?- sublist(S,[a,b,c,d,e]).

% trova tutte le sottoliste di [a,b,c,d,e] escludendo la lista vuota.
?- sublist(S,[a,b,c,d,e]),S=[_|_].

*/

