/* file: minimo.pl
   grammatica per l'Italiano

   dare il goal nella forma: frase(N).
   dove N e'un numero corrispondente ai fatti che seguono
*/   

/* TRANSITIVA */
ff(1,[mario,legge,il,rapporto]).
ff(2,[nel,film,mario,legge,il,rapporto]).

/* INTRANSITIVA */
ff(3,[il,ragazzo,corse,a,casa]).
ff(4,[arriva,a,casa,il,ragazzo]).

/* RELATIVA SULL'OGGETTO */
ff(5,[il,padrone,mangia,la,mela,che,gino,ha,perso]).

/* RELATIVA SUL SOGGETTO */
ff(6,[il,ragazzo,legge,il,libro,che,parla,di,storia]).

/* INFINITIVA TRANSITIVA*/
ff(7,[lo,studente,dice,di,sapere,la,storia]).

/* INFINITIVA INTRANSITIVA*/
ff(8,[il,fratello,dice,di,giocare,a,basket]).

/* FRASE COMPLEMENTO */
ff(9,[il,delegato,ritiene,che,la,casa,sia,del,suocero]).

/* FORMATTAZIONE DELL'OUTPUT SOTTO FORMA DELLA FRASE DESIDERATA */
/* E RELATIVO ALBERO SINTATTICO */
    frase(N):- ff(N,Frase), frase(X, nil, Frase, []),
    write(Frase),nl,
    ppp(X,0).



/* FRASE TRANSITIVA,INTRANSITIVA,INFINITIVA E FRASI DI FRASE */
/* SENZA CONTROLLI CON RELATIVA */
frase(X,H)-->asserzione(X,H).

/* ASSERZIONE */
asserzione(X,H) -->
 attiva_transitiva(X,H).
asserzione(X,H) -->
 attiva_intrans(X,H).

/* ATTIVA TRANSITIVA */
attiva_transitiva(asserzione(indice(Simb),regola(attiva_trans),
		 v(Verbo,Modo,Tempo,Pers,Num),
		 args(Args)),H1) -->    
 sintagmi_preposizionali(ListaSP1,_,H1),
 soggetto(SN1,H1,H2),      
 verbo(v(Verbo,Modo,Tempo,Pers,Num)),   
 {gen_sym(f,Simb)},
 oggetto(Oggetto,H2,nil),
 sintagmi_preposizionali(ListaSP2),
 { Args=[prep1(ListaSP1),sogg(SN1),ogg(Oggetto),prep2(ListaSP2)] }.

attiva_transitiva(asserzione(indice(Simb),regola(attiva_trans),
		 v(Verbo,Modo,Tempo,Pers,Num),
		 arg(Args)),H1) -->    
 sintagmi_preposizionali(ListaSP1,_,H1),
 soggetto(SN1,H1,H2),      
 verbo(v(Verbo,Modo,Tempo,Pers,Num)),   
 {gen_sym(f,Simb)},
 sintagmi_preposizionali(ListaSP2),
 oggetto(Oggetto,H2,nil),
 { Args=[prep1(ListaSP1),sogg(SN1),ogg(Oggetto),prep2(ListaSP2)] }.

/* ATTIVA INTRANSITIVA */
attiva_intrans(asserzione(indice(Simb),regola(attiva_intrans),
	      v(Verbo,Modo,Tempo,Pers,Num),
	      args(Args)),H0) -->
 soggetto(SN1,H0,H1),
 verbo(v(Verbo,Modo,Tempo,Pers,Num)),
 { gen_sym(f,Simb) },
 sintagmi_preposizionali(LSP,H1,nil),
 { Args=[sogg(SN1),ogg(LSP)] }.

/* attiva intransitiva soggetto posposto */
attiva_intrans(asserzione(indice(Simb),regola(attiva_intrans),
	      v(Verbo,Modo,Tempo,Pers,Num),
	      args(Args)),H0) -->
 verbo(v(Verbo,Modo,Tempo,Pers,Num)),
 { gen_sym(f,Simb) },
 sintagmi_preposizionali(ListaSP,H0,H1),
 soggetto(SN1,H1,nil),
 { Args=[sogg(SN1),ogg(ListaSP)] }.

/* SOGGETTO */
soggetto(SimbContr/_,sn/SimbContr/_/_,nil) -->
 [].
soggetto(SN,H1,H1) -->
 sn(SN,nil,nil).   

/* OGGETTO */
oggetto(SimbContr/_,sn/SimbContr/_/_,nil) -->
 [].
oggetto(SN,H1,H1) -->
 sn(SN,nil,nil).
/*infinitiva*/
oggetto(Svinf,H0,nil) -->
 complemento_inf(Svinf,H0,nil).
/*completiva*/
oggetto(Fcomp,H0,nil) -->
 { member(f/prop/_,_) },!,
 fcomp(Fcomp,H0,nil);
 fcomp(Fcomp,nil,nil).

/* COMPLEMENTO_INF */
complemento_inf(inf(P,Inf),H0,H1) -->
 prep(P),infinitiva(Inf,H0,H1).
complemento_inf(inf([],Inf),H0,H1) -->
 infinitiva(Inf,H0,H1).

/* FCOMP */
fcomp(Fcomp,H0,nil) -->
 [che], asserzione(Fcomp,H0).

/* INFINITIVA */
infinitiva(I,H0,H1) -->
 infinitiva_trans(I,H0,H1).
infinitiva(I,H0,H1) -->
 infinitiva_intr(I,H0,H1).

/* INFINITIVA_TRANS */
infinitiva_trans(infinitiva(indice(Simb),regola(infinitiva_trans),
		v(Verbo,Modo,Tempo,Pers,Num),
		args(Argomenti_sv)),H0,nil) -->
 verbo(v(Verbo,Modo,Tempo,Pers,Num)),
 { gen_sym(finf,Simb) } ,
 sintagmi_preposizionali(LSP1,H0,H1),
 oggetto(Ogg,H1,nil),
 { Argomenti_sv = [prepinf(LSP1),oggettoinf(Ogg)] }.

/* INFINITIVA_INTR */
infinitiva_intr(infinitiva(indice(Simb),regola(infinitiva_intr),
	       v(Verbo,Modo,Tempo,Pers,Num),
	       args(Argomenti_sv)),H0,nil) -->
 verbo(v(Verbo,Modo,Tempo,Pers,Num)),
 { gen_sym(finf,Simb) } ,
 sintagmi_preposizionali(LSP,H0,nil),
 { Argomenti_sv = prepinf(LSP) }.

/* SN */
sn(sn(indice(Simb),Det,Testa,
   args(_),mods(Mods)),
   H,H) -->
 determinante(Det,Gen,Num),
 testa(Testa,Gen,Num),
 {gen_sym(sn,Simb)},
 relative(R,TipoR,Testa),
 {Mods=rel(R,TipoR,Simb)}.


/* DETERMINANTE */
determinante(artic(Art,Gen,Num),Gen,Num) -->
 art(Art,Gen,Num).
determinante(artic([]),_,_) -->
 [].

/* ART */
art(Art,Gen,Num) --> [X], {art_d(X,Art,Gen,Num)} .

art_d(X,X,Gen,sing) :- art_det(X,Gen,sing).
art_d(X,X,Gen,plur) :- art_det(X,Gen,plur).

art_i(X,X,Gen,sing) :- art_ndet(X,Gen,sing).

/* ART_DET */
/* definizione del "fatto" articoli determinativi */
art_det(il,mas,sing).
art_det(i,mas,plur).
art_det(lo,mas,sing).
art_det(gli,mas,plur).
art_det(la,fem,sing).
art_det(le,fem,plur).

/* ART_NDET */
/* definizione del "fatto" articoli indeterminativi */
art_ndet(un,mas,sing).
art_ndet(una,fem,sing).
art_ndet(uno,sing).

/* SINTAGMI_PREPOSIZIONALI */
sintagmi_preposizionali(ListaSP,H,H) -->
 sintagmi_preposizionali(ListaSP).
/* lista sintagmi preposizionali */
sintagmi_preposizionali([SP|AltriSP]) -->
 sp(SP),sintagmi_preposizionali(AltriSP).
sintagmi_preposizionali([]) -->
 [].

/* SP */
sp(sp(prep(P,[]),SN)) -->
 prep(P),sn(SN,nil,nil).
sp(sp(prep(P,Mod),SN)) -->
 mod_sp(Mod),prep(P),sn(SN,nil,nil).

/* MOD_SP */
mod_sp(mod(solo)) -->
 [solo].

/* PREP */
/* definizione del "fatto" preposizione semplice e articolata */
prep('/') --> ['/'].
prep(a) --> [a].
prep(a) --> [ad].
prep(con) --> [con].
prep(di) --> [di].
prep(in) --> [in].
prep(su) --> [su].
prep(da) --> [da].
prep(per) --> [per].

prep(contro) --> [contro].
prep(verso) --> [verso].
prep(come) --> [come].
prep(sopra) --> [sopra].
prep(sopra_di) --> [sopra_di].

prep(P) --> prepart(P).

prepart(a,[al|Seq],[il|Seq]).
prepart(a,[ai|Seq],[i|Seq]).
prepart(a,[allo|Seq],[lo|Seq]).
prepart(a,[agli|Seq],[gli|Seq]).
prepart(a,[alla|Seq],[la|Seq]).
prepart(a,[alle|Seq],[le|Seq]).

prepart(da,[dal|Seq],[il|Seq]).
prepart(da,[dai|Seq],[i|Seq]).
prepart(da,[dallo|Seq],[lo|Seq]).
prepart(da,[dagli|Seq],[gli|Seq]).
prepart(da,[dalla|Seq],[la|Seq]).
prepart(da,[dalle|Seq],[le|Seq]).

prepart(con,[col|Seq],[il|Seq]).
prepart(con,[coi|Seq],[i|Seq]).
prepart(con,[collo|Seq],[lo|Seq]).
prepart(con,[cogli|Seq],[gli|Seq]).
prepart(con,[colla|Seq],[la|Seq]).
prepart(con,[colle|Seq],[le|Seq]).

prepart(di,[del|Seq],[il|Seq]).
prepart(di,[dei|Seq],[i|Seq]).
prepart(di,[dello|Seq],[lo|Seq]).
prepart(di,[degli|Seq],[gli|Seq]).
prepart(di,[della|Seq],[la|Seq]).
prepart(di,[delle|Seq],[le|Seq]).

prepart(in,[nel|Seq],[il|Seq]).
prepart(in,[nei|Seq],[i|Seq]).
prepart(in,[nello|Seq],[lo|Seq]).
prepart(in,[negli|Seq],[gli|Seq]).
prepart(in,[nella|Seq],[la|Seq]).
prepart(in,[nelle|Seq],[le|Seq]).

prepart(su,[sul|Seq],[il|Seq]).
prepart(su,[sui|Seq],[i|Seq]).
prepart(su,[sullo|Seq],[lo|Seq]).
prepart(su,[sugli|Seq],[gli|Seq]).
prepart(su,[sulla|Seq],[la|Seq]).
prepart(su,[sulle|Seq],[le|Seq]).

/* TESTA */
testa(n(Nome,Gen,Num),Gen,Num) -->
 nome(Nome,Gen,Num),!.
testa(npro(Nopro,Gen,Num),Gen,Num) -->
 nopro(Nopro,Gen,Num),!.

/* NOME */
nome(Nome,Gen,Num) --> [X], {nome_x(X,Nome,Gen,Num)} .

nome_x(X,X,Gen,sing) :- n(X,_,Gen).
nome_x(X,Y,Gen,plur) :- n(Y,X,Gen).


/* N */
/* definizione del "fatto" nome comune */
n(area,aree,fem).
n(aria,'?? ',fem).
n(attacco,attacchi,mas).
n(bolla,bolle,fem).
n(bollicina,bollicine,fem).
n(bordo,bordi,mas).
n(controllo,controlli,mas).
n(difettosita_,difettosita_,fem).
n(dispositivo,dispositivi,mas).
n(capoturno,capoturni,mas).
n(corrosione,corrosioni,mas).
n(cottura,cotture,fem).
n(croce,croci,fem).
n(fetta,fette,fem).
n(formazione,formazioni,fem).
n(grado,gradi,mas).
n(graffio,graffi,mas).
n(linea,linee,fem).
n(mascheratura,mascherature,fem).
n(mese,mesi,mas).
n(metodo,metodi,mas).
n(microscopio,microscopi,mas).
n(minuto,minuti,mas).
n(operaio,operai,mas).
n(operazione,operazioni,fem).
n(ossido,ossidi,mas).
n(percorso,percorsi,mas).
n(punto,punti,mas).
n(residuo,residui,mas).
n(resist,'?? ',mas).
n(run,run,mas).
n(serie,serie,fem).
n(settimana,settimane,fem).
n(sollevamento,sollevamenti,mas).
n(sovrattacco,sovrattachi,mas).
n(spessore,spessori,mas).
n(sporco,sporchi,mas).
n(stufa,stufe,fem).
n(basket,basket,mas).
n(temperatura,temperature,fem).
n(tempo,tempi,mas).
n('THFE','?? ',mas).
n(volta,volte,fem).
n(velo,veli,mas).
n(wafer,wafer,mas).
n(persona,persone,fem).

n(ministro,ministri,mas).
n(commercio,commerci,mas).
n(suocero,suoceri,mas).
n(occasione,occasioni,fem).
n(posto,posti,mas).
n(organizzazione,organizzazioni,fem).
n(delegato,delegati,mas).
n(funzionario,funzionari,mas).
n(incarico,incarichi,mas).
n(rapporto,rapporti,mas).
n(delegazione,delegazioni,fem).
n(produttore,produttori,mas).
n(ditta,ditte,fem).
n(stampa,'?? ',fem).
n(compito,compiti,mas).
n(vocazione,vocazioni,fem).
n(agilita_,agilita_,fem).
n(collegio,collegi,mas).
n(presidenza,presidenze,fem).
n(fiera,fiere,fem).
n(collaborazione,collaborazioni,fem).
n(distinzione,distinzioni,fem).
n(segretario,segretari,mas).
n(prefetto,prefetti,mas).
n(questore,questori,mas).
n(ex_ufficiale,ex_ufficiali,mas).

n(padrone,padroni,mas).
n(ragazzo,ragazzi,mas).
n(ragazza,ragazze,fem).
n(asino,asini,mas).
n(toro,tori,mas).
n(uomo,uomini,mas).
n(libro,libri,mas).
n(giocattolo,giocattoli,mas).
n(cannocchiale,cannocchiali,mas).
n(mamma,mamme,fem).
n(bambino,bambini,mas).
n(vino,vini,mas).
n(biblioteca,biblioteche,mas).
n(dispiacere,dispiaceri,mas).
n(partenza,partenze,fem).
n(imputato,imputati,mas).
n(casa,case,fem).
n(finestra,finestre,fem).
n(salute,'?? ',fem).
n(moglie,mogli,fem).
n(sorella,sorelle,fem).
n(fratello,fratelli,mas).
n(padre,padri,mas).
n(madre,madri,fem).
n(famiglia,famiglie,fem).
n(insegnante,insegnanti,mas).
n(studente,studenti,mas).
n(liberta_,liberta_,fem).
n(film,film,mas).
n(genio,geni,mas).
n(trasmissione,trasmissioni,fem).
n(storia,storie,fem).
n(ora,ore,fem).
n(giorno,giorni,mas).
n(tre,tre,fem).
n(mela,mele,fem).

/* NOPRO */
nopro(Nopro,Gen,Num) --> [X], {nopro_x(X,Nopro,Gen,Num)} .

nopro_x(X,X,Gen,sing) :- npro(X,_,Gen).
nopro_x(X,Y,Gen,plur) :- npro(Y,X,Gen).

/* NPRO */
/* definizione del "fatto" nome proprio */
npro(avveduti,'?? ',mas).
npro(verona,'?? ',fem).
npro(alberti,'?? ',mas).
npro(trabucchi,'?? ',mas).
npro(1950,'?? ',mas).
npro(novara_cavalleria,'?? ',mas).

npro(marco,'?? ',mas).
npro(mario,'?? ',mas).
npro(maria,'?? ',fem).
npro(francesca,'?? ',fem).
npro(luigi,'?? ',mas).
npro(gino,'?? ',mas).
npro('Bob','?? ',mas).
npro('massimo','??',mas).

/* RELATIVE */
relative(R,restr,Controller) -->
 [che],
 {gen_sym(sn,_)},
 asserzione(R,sn/Controller/_/prorel(pro,_,_,_,[nom,acc])),
 ([] ; [',']).
relative(R,appos,Controller) -->
 [','],
 [che],
 {gen_sym(sn,_)},
 asserzione(R,sn/Controller/_/prorel(pro,_,_,_,[nom,acc])),
 [','].
relative([],nil,_) -->
 [].

/* VERBO */
verbo(v(Vinf,Modo,Tempo/semp,Persona,Numero)) -->
 [Verbo], { v(Verbo,Vinf,Modo,Tempo,Persona,Numero) } .
verbo(v(Vinf,Modo,Tempo/comp/Ainf,Persona,Numero)) -->
 ausiliare(aux(Ainf,Modo,Tempo,Persona,Numero)),
 participio(Vinf,_,_).

/* V */
/* definizione del "fatto" verbo */
v(accenno,accennare,ind,pres,1,sing).
v(accenna,accennare,ind,pres,3,sing).
v(attaccare,attaccare,inf,_,_,_).
v(cercava,cercare,ind,imp,3,sing).
v(corre,correre,ind,pres,3,sing).
v(corse,correre,ind,pass_rem,3,sing).
v(correra_,correre,ind,futuro,3,sing).
v(correndo,correre,ger,_,_,_).
v(considera,considerare,ind,pres,3,sing).
v(considerano,considerare,ind,pres,3,plur).
v(fa,fare,ind,pres,3,sing).
v(mangia,mangiare,ind,pres,3,sing).
v(mangiare,mangiare,inf,pres,_,_).
v(ordina,ordinare,ind,pres,3,sing).
v(ordinare,ordinare,inf,_,_,_).
v(rende,rendere,ind,pres,3,sing).
v(rendono,rendere,ind,pres,3,plur).
v(rimuove,rimuovere,ind,pres,3,sing).
v(rimuovere,rimuovere,inf,_,_,_).
v(ripetere,ripetere,inf,_,_,_).
v(ripete,ripetere,ind,pres,3,sing).
v(dice,dire,ind,pres,3,sing).
v(dici,dire,ind,pres,2,sing).
v(avvisare,avvisare,inf,_,_,_).
v(rileva,rilevare,ind,pres,3,sing).
v(rilevare,rilevare,inf,_,_,_).
v(parlare,parlare,inf,_,_,_).
v(parlava,parlare,ind,imp,3,sing).
v(parlando,parlare,ger,pres,_,_).
v(parli,parlare,cong,pres,3,sing).
v(parla,parlare,ind,pres,3,sing).
v(attaccare,attaccare,inf,_,_,_).
v(esiste,esistere,ind,pres,3,sing).
v(piacere,piacere,inf,_,_,_).
v(piaceva,piacere,ind,imp,3,sing).
v(piace,piacere,ind,pres,3,sing).
v(piacciono,piacere,ind,pres,3,plur).
v(durare,durare,inf,_,_,_).
v(durava,durare,ind,imp,3,sing).
v(dura,durare,ind,pres,3,sing).
v(durano,durare,ind,pres,3,plur).
v(sembrare,sembrare,inf,_,_,_).
v(sembrava,sembrare,ind,imp,3,sing).
v(sembra,sembrare,ind,pres,3,sing).
v(sembrano,sembrare,ind,pres,3,plur).
v(preferire,preferire,inf,_,_,_).
v(preferiva,preferire,ind,imp,3,sing).
v(lasciare,lasciare,inf,_,_,_).
v(lascera_,lasciare,ind,futuro,3,sing).
v(perdere,perdere,inf,_,_,_).
v(perse,perdere,ind,pass_rem,3,sing).
v(rassegno_,rassegnarsi,ind,pass_rem,3,sing).
v(rassegnarsi,rassegnarsi,inf,_,_,_).
v(accettare,accettare,inf,_,_,_).
v(nomimare,nominare,inf,_,_,_).
v(nominarono,nominare,ind,pass_rem,3,plur).
v(tenere,tenere,inf,_,_,_).
v(curare,curare,inf,_,_,_).
v(corrispondere,corrispondere,inf,_,_,_).
v(corrispondeva,corrispondere,ind,imp,3,sing).
v(sapere,sapere,inf,_,_,_).
v(sapeva,sapere,ind,imp,3,sing).
v(sai,sapere,ind,pres,2,sing).
v(giostrare,giostrare,inf,_,_,_).
v(giostrava,giostrare,ind,imp,3,sing).
v(morire,morire,inf,_,_,_).
v(mori_,morire,ind,pass_rem,3,sing).
v(ereditare,ereditare,inf,_,_,_).
v(sfruttare,sfruttare,inf,_,_,_).
v(batte,battere,ind,pres,3,sing).
v(legge,leggere,ind,pres,3,sing).
v(regala,regalare,ind,pres,3,sing).
v(regalo_,regalare,ind,pass_rem,3,sing).
v(spronare,spronare,inf,_,_,_).
v(sprona,spronare,ind,pres,3,sing).
v(aspetta,aspettare,ind,pres,3,sing).
v(aspettava,aspettare,ind,imp,3,sing).
v(ubbidisce,ubbidire,ind,pres,3,sing).
v(provoco_,provocare,ind,pass_rem,3,sing).
v(incontri,incontrare,ind,pres,2,sing).
v(portare,portare,inf,_,_,_).
v(giocare,giocare,inf,_,_,_).
v(accusava,accusare,ind,imp,3,sing).
v(accusare,accusare,inf,_,_,_).
v(continuo_,continuare,ind,pass_rem,3,sing).
v(valersi,valersi,inf,_,_,_).
v(impressionava,impressionare,ind,imp,3,sing).
v(confermo_,confermare,ind,pass_rem,3,sing).
v(funzionava,funzionare,ind,imp,3,sing).
v(mobilitare,mobilitare,inf,_,_,_).
v(era,essere,ind,imp,3,sing).
v(parte,partire,ind,pres,3,sing).
v(partiva,partire,ind,imp,3,sing).
v(partira_,partire,ind,futuro,3,sing).
v(parti_,partire,ind,pass_rem,3,sing).
v(partire,partire,inf,_,_,_).
v(arriva,arrivare,ind,pres,3,sing).
v(arrivava,arrivare,ind,imp,3,sing).
v(arrivera_,arrivare,ind,futuro,3,sing).
v(arrivo_,arrivare,ind,pass_rem,3,sing).
v(arrivare,arrivare,inf,_,_,_).
v(controllare,controllare,inf,_,_,_).
v(rubare,rubare,inf,_,_,_).
v(rubo_,rubare,ind,pass_rem,3,sing).
v(insultava,insultare,ind,imp,3,sing).
v(insulto_,insultare,ind,pass_rem,3,sing).
v(dire,dire,inf,_,_,_).
v(vide,vedere,ind,pass_rem,3,sing).
v(vede,vedere,ind,pres,3,sing).
v(sposera_,sposare,ind,futuro,3,sing).
v(interrogai,interrogare,ind,pass_rem,1,sing).
v(invidia,invidiare,ind,pres,3,sing).
v(invidiavano,invidiare,ind,imp,3,plur).
v(invidava,invidiare,ind,imp,3,sing).
v(ama,amare,ind,pres,3,sing).
v(amava,amare,ind,imp,3,sing).
v(ami,amare,cong,pres,_,sing).
v(preoccupa,preoccupare,ind,pres,3,sing).
v(ritiene,ritenere,ind,pres,3,sing).
v(promosse,promuovere,ind,pass_rem,3,sing).
v(pensi,pensare,cong,pres,3,sing).
v(pensa,pensare,ind,pres,3,sing).

v(ha,avere,ind,pres,3,sing).
v(hai,avere,ind,pres,2,sing).

v(e_,essere,ind,pres,3,sing).
v(sono,essere,ind,pres,3,plur).
v(sia,essere,cong,pres,3,sing).

/* AUSILIARE */
ausiliare(aux(Ainf,Modo,Tempo,Persona,Numero)) -->
 [Aux], { aux(Aux,Ainf,Modo,Tempo,Persona,Numero) } .

/* AUX */
/* definizione del "fatto" ausiliare */
aux(viene,venire,ind,pres,3,sing).
aux(vengono,venire,ind,pres,3,plur).
aux(aveva,avere,ind,imp,3,sing).
aux(avevano,avere,ind,imp,3,plur).
aux(avrebbe,avere,cong,pass,3,sing).  /* che tempo ? */
aux(avere,avere,inf,pres,_,_).
aux(ha,avere,ind,pres,3,sing).
aux(ho,avere,ind,pres,1,sing).
aux(avere,avere,inf,_,_,_).
aux(sia,essere,cong,pres,_,sing).
aux(e_,essere,ind,pres,3,sing).
aux(era,essere,ind,imp,3,sing).
aux(sara_,essere,ind,futuro,3,sing).
aux(sta,stare,ind,pres,3,sing).
aux(stava,stare,ind,imp,3,sing).

/* PARTICIPIO */
participio(Verbo,Gen,Num) -->
 [X], {pp_x(X,Verbo,Gen,Num)} .

pp_x(X,V,mas,sing) :- pp(X,_,_,_,V).
pp_x(X,V,mas,plur) :- pp(_,X,_,_,V).
pp_x(X,V,fem,sing) :- pp(_,_,X,_,V).
pp_x(X,V,fem,plur) :- pp(_,_,_,X,V).

/* PP */
/* definizione del "fatto" participio */
pp(controllato,controllati,controllata,controllate,controllare).
pp(corso,corsi,corsa,corse,correre).
pp(incaricato,incaricati,incaricata,incaricate,incaricare).
pp(rilevato,rilevati,rilevata,rilevate,rilevare).
pp(sfruttato,sfruttata,sfruttati,sfruttate,sfruttare).
pp(ereditato,ereditati,ereditata,ereditate,ereditare).
pp(accennato,accennati,accennata,accennate,accennare).
pp(ordinato,ordinati,ordinata,ordinate,ordinare).
pp(incontrato,incontrati,incontrata,incontrate,incontrare).
pp(perso,persa,persi,perse,perdere).
pp(rubato,rubati,rubata,rubate,rubare).
pp(detto,detti,detta,dette,dire).
pp(insultato,insultati,insultata,insultate,insultare).
pp(lasciato,lasciati,lasciata,lasciate,lasciare).
pp(fatto,fatti,fatta,fatte,fare).
pp(accusato,accusati,accusata,accusate,accusare).
pp(visto,visti,vista,viste,vedere).
pp(amato,amati,amata,amate,amare).
pp(nominato,nominati,nominata,nominate,nominare).
pp(mangiato,mangiati,mangiate,mangiata,mangiare).
pp(partito,partiti,partita,partite,arrivate).
pp(arrivato,arrivati,arrivata,arrivate,arrivare).
pp(stato,stati,stata,state,essere).
pp(avuto,avuti,avuta,avute,avere).
pp(cercato,cercati,cercata,cercate,cercare).
pp(aspettato,aspettati,aspettata,aspettate,aspettare).

/* Generazione di simboli */
/* la chiamata    gen_sym(Radice,0) inizializza il generatore  */
/*  per la radice Radice  */

gen_sym(Radice,X) :- nonvar(X), !, X = 0,
		    retractall(current_num(Radice,_N)).

gen_sym(Radice,Atomo) :- get_num(Radice,Num),
			name(Radice,Name1),
			name(Num,Name2),
			append(Name1,Name2,Name),
			name(Atomo,Name).

get_num(Radice,Num) :- retract(current_num(Radice,Num1)), !,
		       Num is Num1 + 1,
		       assert(current_num(Radice,Num)).
get_num(Radice,1)   :- assert(current_num(Radice,1)).

/* RETRACTALL */
retractall(X) :- retract(X),fail.
retractall(_).

/* pretty print */
ppp(X,I) :- atomic(X),tab(I),write(X),nl, !.
ppp([],I) :- tab(I),write([]),nl,!.
ppp([H|T],I) :- !,
          J is I + 1, ppp(H,J), ppx(T,J),
          !.
ppp(Struttura,I) :- Struttura =.. [Func|[[]]],
          tab(I),write(Func),tab(1),write([]),nl,!.
ppp(Struttura,I) :- Struttura =.. [Func|_],
          member(Func,
  [artic,regola,indice,n,npro,pr,prorel,a,v,aux,supporto,
          pp,def,part,card,prep,cat,sub,controllore,ruolo,implicito,
          possessivo]),
          tab(I),write(Struttura),nl,!.
ppp(Struttura,I) :- Struttura =.. [Func|Args],tab(I),write(Func),nl,
          J is I + 1, ppp(Args,J),!.

ppx([],_) :- !.
ppx([H|T],I) :- ppp(H,I), ppx(T,I), !.


