/* file: controlli.pl
   grammatica per l'Italiano
   comprende dei controlli semantici

   dare il goal nella forma: frase(N).
   dove N e'un numero corrispondente ai fatti che seguono
*/   


/*TRANSITIVE CORRETTE*/

ff(1,[mario,legge,il,rapporto]).
ff(2,[mario,legge,il,rapporto,in,biblioteca]).
ff(3,[nel,film,mario,legge,il,rapporto]).
ff(4,[nel,film,mario,legge,il,rapporto,in,biblioteca]).
ff(5,[nel,film,mario,legge,in,biblioteca,il,rapporto]).

/*TRANSITIVE SBAGLIATE*/

ff(6,[il,padrone,mangia,la,casa]).
ff(7,[il,padrone,mangia,la,casa,in,famiglia]).
ff(8,[nel,collegio,il,padrone,mangia,la,casa]).

/*INTRANSITIVE CORRETTE*/

ff(9,[il,ragazzo,corse,alla,fiera]).
ff(10,[arriva,in,ditta,lo,suocero]).

/*INTRANSITIVE SBAGLIATE*/

ff(11,[la,casa,corse,in,fiera]).
ff(12,[arriva,in,presidenza,la,finestra]).

/*FORMATTAZIONE DELL'OUTPUT SOTTO FORMA DELLA FRASE DESIDERATA*/
/*E RELATIVO ALBERO SINTATTICO*/
    
frase(N):- ff(N,Frase), 
 write(Frase),nl, !,
 frase(X, nil, Frase, []), 
 ppp(X,0).

/*------------------------------------------------------------------------*/
/*FRASI TRANSITIVE E INTRANSITIVE CON CONTROLLI TRA I FUNTORI             */
/*SOGGETTO,VERBO E OGGETTO                                                */
/*------------------------------------------------------------------------*/

/*FRASE*/

frase(X,H)-->
 asserzione(X,H).

/* ASSERZIONE */

asserzione(X,H) -->
 attiva_transitiva(X,H).
asserzione(X,H) -->
 attiva_intrans(X,H).

/* ATTIVA TRANSITIVA */

/* Sogg,verbo,oggetto/sn */
attiva_transitiva(asserzione(indice(Simb),regola(attiva_trans),
		 v(Verbo,Modo,Tempo,Pers,Num),sem(ListaArgsVerbo),
             args(Args)),H1) -->    
 sintagmi_preposizionali(ListaSP1,_,H1),
 soggetto(Soggetto,ContrSogg,H1,H2), 
 verbo(v(Verbo,Modo,Tempo,Pers,Num)),   
 {gen_sym(f,Simb)},
 oggetto(Oggetto,ContrOgg,H2,nil),
 sintagmi_preposizionali(ListaSP2),

 {pred(verbo,Verbo,trans,_,ListaArgsVerbo),
 ContrSogg=sn/ListaCatsSogg,
 member(sn/sogg/_/Lsogg,ListaArgsVerbo),
 member(X1,ListaCatsSogg),
 member(X1,Lsogg),
 ContrOgg=TipoOgg/ListaCatsOgg,
 (TipoOgg=sn,
 member(TipoOgg/ogg/_/Logg,ListaArgsVerbo),
 member(X2,ListaCatsOgg),
 member(X2,Logg)
 ;
 member(TipoOgg/_,ListaArgsVerbo))},
 
 {Args=[prep1(ListaSP1),sogg(Soggetto),ogg(Oggetto),prep2(ListaSP2)]}.

attiva_transitiva(asserzione(indice(Simb),regola(attiva_trans),
		 v(Verbo,Modo,Tempo,Pers,Num),sem(ListaArgsVerbo),
             args(Args)),H1) -->    
 sintagmi_preposizionali(ListaSP1,_,H1),
 soggetto(Soggetto,ContrSogg,H1,H2),      
 verbo(v(Verbo,Modo,Tempo,Pers,Num)),   
 {gen_sym(f,Simb)},
 sintagmi_preposizionali(ListaSP2),
 oggetto(Oggetto,ContrOgg,H2,nil),
 
 {pred(verbo,Verbo,trans,_,ListaArgsVerbo),
 ContrSogg=sn/ListaCatsSogg,
 member(sn/sogg/_/Lsogg,ListaArgsVerbo),
 member(X1,ListaCatsSogg),
 member(X1,Lsogg),
 ContrOgg=TipoOgg/ListaCatsOgg,
 (TipoOgg=sn,
 member(TipoOgg/ogg/_/Logg,ListaArgsVerbo),
 member(X2,ListaCatsOgg),
 member(X2,Logg)
 ;
 member(TipoOgg/_,ListaArgsVerbo))},

 {Args=[prep1(ListaSP1),sogg(Soggetto),ogg(Oggetto),prep2(ListaSP2)]}.

/* ATTIVA INTRANSITIVA */

attiva_intrans(asserzione(indice(Simb),regola(attiva_intrans),
	      v(Verbo,Modo,Tempo,Pers,Num),sem(ListaArgsVerbo),
	      args(Args)),H0) -->
 soggetto(Soggetto,ContrSogg,H0,H1),
 verbo(v(Verbo,Modo,Tempo,Pers,Num)),
 {gen_sym(f,Simb)},
 sintagmi_preposizionali(ListaSP1,H1,nil),

 {pred(verbo,Verbo,intr,_,ListaArgsVerbo),
 ContrSogg=sn/ListaCatsSogg,
 member(sn/sogg/_/Lsogg,ListaArgsVerbo),
 member(X1,ListaCatsSogg),
 member(X1,Lsogg)},

 {Args=[sogg(Soggetto),obl(ListaSP1)]}.

/* attiva intransitiva soggetto posposto */
attiva_intrans(asserzione(indice(Simb),regola(attiva_intrans),
	      v(Verbo,Modo,Tempo,Pers,Num),sem(ListaArgsVerbo),
	      args(Args)),H0) -->
 verbo(v(Verbo,Modo,Tempo,Pers,Num)),
 {gen_sym(f,Simb)},
 sintagmi_preposizionali(ListaSP1,H0,H1),
 soggetto(Soggetto,ContrSogg,H1,nil),

 {pred(verbo,Verbo,intr,_,ListaArgsVerbo),
 ContrSogg=sn/ListaCatsSogg,
 member(sn/sogg/_/Lsogg,ListaArgsVerbo),
 member(X1,ListaCatsSogg),
 member(X1,Lsogg)},

 {Args=[sogg(Soggetto),ogg(ListaSP1)]}.

/* SOGGETTO */

soggetto(_,_,nil) -->
 [].
soggetto(SN,sn/ListaCats,H1,H1) -->
 sn(SN,ListaCats,nil,nil).   

/* OGGETTO */

oggetto(SimbContr/_,sn/SimbContr/_/_,nil) -->
 [].
oggetto(SN,sn/ListaCats,H1,H1) -->
 sn(SN,ListaCats,nil,nil).

/* SN */

sn(sn(indice(Simb),Det,Testa,sem(ListaCats),args(_)),
    ListaCats,
   H,H) -->
 determinante(Det,Gen,Num),
 testa(Testa,Gen,Num,ListaCats),
 {gen_sym(sn,Simb)}.

/* DETERMINANTE */

determinante(artic(Art,Gen,Num),Gen,Num) -->
 art(Art,Gen,Num).
determinante(artic([]),_,_) -->
 [].

/* ART */

art(Art,Gen,Num) --> [X], {art_d(X,Art,Gen,Num)} .

art_d(X,X,Gen,sing) :- art_det(X,Gen,sing).
art_d(X,X,Gen,plur) :- art_det(X,Gen,plur).

art(Art,Gen,Num) --> [X], {art_i(X,Art,Gen,Num)}.

art_i(X,X,Gen,sing) :- art_ndet(X,Gen,sing).

/* ART_DET */
	       /* definizione del "fatto" articoli determinativi */

art_det(il,mas,sing).
art_det(i,mas,plur).
art_det(lo,mas,sing).
art_det(gli,mas,plur).
art_det(la,fem,sing).
art_det(le,fem,plur).

/* ART_NDET */
	      /* definizione del "fatto" articoli indeterminativi */

art_ndet(un,mas,sing).
art_ndet(una,fem,sing).
art_ndet(uno,sing).

/* SINTAGMI_PREPOSIZIONALI */

sintagmi_preposizionali(ListaSP,H,H) -->
 sintagmi_preposizionali(ListaSP).
/* lista sintagmi preposizionali */
sintagmi_preposizionali([SP|AltriSP]) -->
 sp(SP),sintagmi_preposizionali(AltriSP).
sintagmi_preposizionali([]) -->
 [].

/* SP */

sp(sp(prep(P),SN)) -->
 prep(P),sn(SN,_,nil,nil).

/* PREP */
            /* definizione del "fatto" preposizione semplice e articolata */

prep('/') --> ['/'].
prep(a) --> [a].
prep(a) --> [ad].
prep(con) --> [con].
prep(di) --> [di].
prep(in) --> [in].
prep(su) --> [su].
prep(da) --> [da].
prep(per) --> [per].

prep(contro) --> [contro].
prep(verso) --> [verso].
prep(come) --> [come].
prep(sopra) --> [sopra].
prep(sopra_di) --> [sopra_di].

prep(P) --> prepart(P).

prepart(a,[al|Seq],[il|Seq]).
prepart(a,[ai|Seq],[i|Seq]).
prepart(a,[allo|Seq],[lo|Seq]).
prepart(a,[agli|Seq],[gli|Seq]).
prepart(a,[alla|Seq],[la|Seq]).
prepart(a,[alle|Seq],[le|Seq]).

prepart(da,[dal|Seq],[il|Seq]).
prepart(da,[dai|Seq],[i|Seq]).
prepart(da,[dallo|Seq],[lo|Seq]).
prepart(da,[dagli|Seq],[gli|Seq]).
prepart(da,[dalla|Seq],[la|Seq]).
prepart(da,[dalle|Seq],[le|Seq]).

prepart(con,[col|Seq],[il|Seq]).
prepart(con,[coi|Seq],[i|Seq]).
prepart(con,[collo|Seq],[lo|Seq]).
prepart(con,[cogli|Seq],[gli|Seq]).
prepart(con,[colla|Seq],[la|Seq]).
prepart(con,[colle|Seq],[le|Seq]).

prepart(di,[del|Seq],[il|Seq]).
prepart(di,[dei|Seq],[i|Seq]).
prepart(di,[dello|Seq],[lo|Seq]).
prepart(di,[degli|Seq],[gli|Seq]).
prepart(di,[della|Seq],[la|Seq]).
prepart(di,[delle|Seq],[le|Seq]).

prepart(in,[nel|Seq],[il|Seq]).
prepart(in,[nei|Seq],[i|Seq]).
prepart(in,[nello|Seq],[lo|Seq]).
prepart(in,[negli|Seq],[gli|Seq]).
prepart(in,[nella|Seq],[la|Seq]).
prepart(in,[nelle|Seq],[le|Seq]).

prepart(su,[sul|Seq],[il|Seq]).
prepart(su,[sui|Seq],[i|Seq]).
prepart(su,[sullo|Seq],[lo|Seq]).
prepart(su,[sugli|Seq],[gli|Seq]).
prepart(su,[sulla|Seq],[la|Seq]).
prepart(su,[sulle|Seq],[le|Seq]).

/* TESTA */

testa(n(Nome,Gen,Num),Gen,Num,ListaCats) -->
 nome(Nome,Gen,Num),
 {pred(nome,Nome,ListaCats,_ListaArgs)}.
testa(npro(Nopro,Gen,Num),Gen,Num,ListaCats) -->
 nopro(Nopro,Gen,Num),
 {pred(nopro,Nopro,ListaCats,_ListaArgs)}.

/* NOME */

nome(Nome,Gen,Num) --> [X], {nome_x(X,Nome,Gen,Num)}.

nome_x(X,X,Gen,sing) :- n(X,_,Gen).
nome_x(X,Y,Gen,plur) :- n(Y,X,Gen).


/* N */
         /* definizione del "fatto" nome comune */

n(area,aree,fem).
n(aria,'?? ',fem).
n(attacco,attacchi,mas).
n(bolla,bolle,fem).
n(bollicina,bollicine,fem).
n(bordo,bordi,mas).
n(controllo,controlli,mas).
n(difettosita_,difettosita_,fem).
n(dispositivo,dispositivi,mas).
n(capoturno,capoturni,mas).
n(corrosione,corrosioni,mas).
n(cottura,cotture,fem).
n(croce,croci,fem).
n(fetta,fette,fem).
n(formazione,formazioni,fem).
n(grado,gradi,mas).
n(graffio,graffi,mas).
n(linea,linee,fem).
n(mascheratura,mascherature,fem).
n(mese,mesi,mas).
n(metodo,metodi,mas).
n(microscopio,microscopi,mas).
n(minuto,minuti,mas).
n(operaio,operai,mas).
n(operazione,operazioni,fem).
n(ossido,ossidi,mas).
n(percorso,percorsi,mas).
n(punto,punti,mas).
n(residuo,residui,mas).
n(resist,'?? ',mas).
n(run,run,mas).
n(serie,serie,fem).
n(settimana,settimane,fem).
n(sollevamento,sollevamenti,mas).
n(sovrattacco,sovrattachi,mas).
n(spessore,spessori,mas).
n(sporco,sporchi,mas).
n(stufa,stufe,fem).
n(temperatura,temperature,fem).
n(tempo,tempi,mas).
n('THFE','?? ',mas).
n(volta,volte,fem).
n(velo,veli,mas).
n(wafer,wafer,mas).
n(persona,persone,fem).

n(ministro,ministri,mas).
n(commercio,commerci,mas).
n(suocero,suoceri,mas).
n(occasione,occasioni,fem).
n(posto,posti,mas).
n(organizzazione,organizzazioni,fem).
n(delegato,delegati,mas).
n(funzionario,funzionari,mas).
n(incarico,incarichi,mas).
n(rapporto,rapporti,mas).
n(delegazione,delegazioni,fem).
n(produttore,produttori,mas).
n(ditta,ditte,fem).
n(stampa,'?? ',fem).
n(compito,compiti,mas).
n(vocazione,vocazioni,fem).
n(agilita_,agilita_,fem).
n(collegio,collegi,mas).
n(presidenza,presidenze,fem).
n(fiera,fiere,fem).
n(collaborazione,collaborazioni,fem).
n(distinzione,distinzioni,fem).
n(segretario,segretari,mas).
n(prefetto,prefetti,mas).
n(questore,questori,mas).
n(ex_ufficiale,ex_ufficiali,mas).

n(padrone,padroni,mas).
n(ragazzo,ragazzi,mas).
n(ragazza,ragazze,fem).
n(asino,asini,mas).
n(toro,tori,mas).
n(uomo,uomini,mas).
n(libro,libri,mas).
n(giocattolo,giocattoli,mas).
n(cannocchiale,cannocchiali,mas).
n(mamma,mamme,fem).
n(bambino,bambini,mas).
n(vino,vini,mas).
n(biblioteca,biblioteche,mas).
n(dispiacere,dispiaceri,mas).
n(partenza,partenze,fem).
n(imputato,imputati,mas).
n(casa,case,fem).
n(finestra,finestre,fem).
n(salute,'?? ',fem).
n(moglie,mogli,fem).
n(sorella,sorelle,fem).
n(fratello,fratelli,mas).
n(padre,padri,mas).
n(madre,madri,fem).
n(famiglia,famiglie,fem).
n(insegnante,insegnanti,mas).
n(studente,studenti,mas).
n(liberta_,liberta_,fem).
n(film,film,mas).
n(genio,geni,mas).
n(trasmissione,trasmissioni,fem).
n(storia,storie,fem).
n(ora,ore,fem).
n(giorno,giorni,mas).
n(tre,tre,fem).
n(mela,mele,fem).

/* NOPRO */

nopro(Nopro,Gen,Num) --> [X], {nopro_x(X,Nopro,Gen,Num)}.

nopro_x(X,X,Gen,sing) :- npro(X,_,Gen).
nopro_x(X,Y,Gen,plur) :- npro(Y,X,Gen).

/* NPRO */
             /* definizione del "fatto" nome proprio */

npro(avveduti,'?? ',mas).
npro(verona,'?? ',fem).
npro(alberti,'?? ',mas).
npro(trabucchi,'?? ',mas).
npro(1950,'?? ',mas).
npro(novara_cavalleria,'?? ',mas).

npro(marco,'?? ',mas).
npro(mario,'?? ',mas).
npro(maria,'?? ',fem).
npro(francesca,'?? ',fem).
npro(luigi,'?? ',mas).
npro(gino,'?? ',mas).
npro('Bob','?? ',mas).

/* VERBO */

verbo(v(Vinf,Modo,Tempo/semp,Persona,Numero)) -->
 [Verbo], { v(Verbo,Vinf,Modo,Tempo,Persona,Numero) } .
verbo(v(Vinf,Modo,Tempo/comp/Ainf,Persona,Numero)) -->
 ausiliare(aux(Ainf,Modo,Tempo,Persona,Numero)),
 participio(Vinf,_,_).

/* V */
       /* definizione del "fatto" verbo */

v(accenno,accennare,ind,pres,1,sing).
v(accenna,accennare,ind,pres,3,sing).
v(attaccare,attaccare,inf,_,_,_).
v(cercava,cercare,ind,imp,3,sing).
v(corre,correre,ind,pres,3,sing).
v(corse,correre,ind,pass_rem,3,sing).
v(correra_,correre,ind,futuro,3,sing).
v(correndo,correre,ger,_,_,_).
v(considera,considerare,ind,pres,3,sing).
v(considerano,considerare,ind,pres,3,plur).
v(fa,fare,ind,pres,3,sing).
v(mangia,mangiare,ind,pres,3,sing).
v(mangiare,mangiare,inf,pres,_,_).
v(ordina,ordinare,ind,pres,3,sing).
v(ordinare,ordinare,inf,_,_,_).
v(rende,rendere,ind,pres,3,sing).
v(rendono,rendere,ind,pres,3,plur).
v(rimuove,rimuovere,ind,pres,3,sing).
v(rimuovere,rimuovere,inf,_,_,_).
v(ripetere,ripetere,inf,_,_,_).
v(ripete,ripetere,ind,pres,3,sing).
v(dice,dire,ind,pres,3,sing).
v(dici,dire,ind,pres,2,sing).
v(avvisare,avvisare,inf,_,_,_).
v(rileva,rilevare,ind,pres,3,sing).
v(rilevare,rilevare,inf,_,_,_).
v(parlare,parlare,inf,_,_,_).
v(parlava,parlare,ind,imp,3,sing).
v(parlando,parlare,ger,pres,_,_).
v(parli,parlare,cong,pres,3,sing).
v(attaccare,attaccare,inf,_,_,_).
v(esiste,esistere,ind,pres,3,sing).
v(piacere,piacere,inf,_,_,_).
v(piaceva,piacere,ind,imp,3,sing).
v(piace,piacere,ind,pres,3,sing).
v(piacciono,piacere,ind,pres,3,plur).
v(durare,durare,inf,_,_,_).
v(durava,durare,ind,imp,3,sing).
v(dura,durare,ind,pres,3,sing).
v(durano,durare,ind,pres,3,plur).
v(sembrare,sembrare,inf,_,_,_).
v(sembrava,sembrare,ind,imp,3,sing).
v(sembra,sembrare,ind,pres,3,sing).
v(sembrano,sembrare,ind,pres,3,plur).
v(preferire,preferire,inf,_,_,_).
v(preferiva,preferire,ind,imp,3,sing).
v(lasciare,lasciare,inf,_,_,_).
v(lascera_,lasciare,ind,futuro,3,sing).
v(perdere,perdere,inf,_,_,_).
v(perse,perdere,ind,pass_rem,3,sing).
v(rassegno_,rassegnarsi,ind,pass_rem,3,sing).
v(rassegnarsi,rassegnarsi,inf,_,_,_).
v(accettare,accettare,inf,_,_,_).
v(nomimare,nominare,inf,_,_,_).
v(nominarono,nominare,ind,pass_rem,3,plur).
v(tenere,tenere,inf,_,_,_).
v(curare,curare,inf,_,_,_).
v(corrispondere,corrispondere,inf,_,_,_).
v(corrispondeva,corrispondere,ind,imp,3,sing).
v(sapere,sapere,inf,_,_,_).
v(sapeva,sapere,ind,imp,3,sing).
v(sai,sapere,ind,pres,2,sing).
v(giostrare,giostrare,inf,_,_,_).
v(giostrava,giostrare,ind,imp,3,sing).
v(morire,morire,inf,_,_,_).
v(mori_,morire,ind,pass_rem,3,sing).
v(ereditare,ereditare,inf,_,_,_).
v(sfruttare,sfruttare,inf,_,_,_).
v(batte,battere,ind,pres,3,sing).
v(legge,leggere,ind,pres,3,sing).
v(leggere,leggere,inf,_,_,_).
v(regala,regalare,ind,pres,3,sing).
v(regalo_,regalare,ind,pass_rem,3,sing).
v(spronare,spronare,inf,_,_,_).
v(sprona,spronare,ind,pres,3,sing).
v(aspetta,aspettare,ind,pres,3,sing).
v(aspettava,aspettare,ind,imp,3,sing).
v(ubbidisce,ubbidire,ind,pres,3,sing).
v(provoco_,provocare,ind,pass_rem,3,sing).
v(incontri,incontrare,ind,pres,2,sing).
v(portare,portare,inf,_,_,_).
v(accusava,accusare,ind,imp,3,sing).
v(accusare,accusare,inf,_,_,_).
v(continuo_,continuare,ind,pass_rem,3,sing).
v(valersi,valersi,inf,_,_,_).
v(impressionava,impressionare,ind,imp,3,sing).
v(confermo_,confermare,ind,pass_rem,3,sing).
v(funzionava,funzionare,ind,imp,3,sing).
v(mobilitare,mobilitare,inf,_,_,_).
v(era,essere,ind,imp,3,sing).
v(parte,partire,ind,pres,3,sing).
v(partiva,partire,ind,imp,3,sing).
v(partira_,partire,ind,futuro,3,sing).
v(parti_,partire,ind,pass_rem,3,sing).
v(partire,partire,inf,_,_,_).
v(arriva,arrivare,ind,pres,3,sing).
v(arrivava,arrivare,ind,imp,3,sing).
v(arrivera_,arrivare,ind,futuro,3,sing).
v(arrivo_,arrivare,ind,pass_rem,3,sing).
v(arrivare,arrivare,inf,_,_,_).
v(controllare,controllare,inf,_,_,_).
v(rubare,rubare,inf,_,_,_).
v(rubo_,rubare,ind,pass_rem,3,sing).
v(insultava,insultare,ind,imp,3,sing).
v(insulto_,insultare,ind,pass_rem,3,sing).
v(dire,dire,inf,_,_,_).
v(vide,vedere,ind,pass_rem,3,sing).
v(vede,vedere,ind,pres,3,sing).
v(sposera_,sposare,ind,futuro,3,sing).
v(interrogai,interrogare,ind,pass_rem,1,sing).
v(invidia,invidiare,ind,pres,3,sing).
v(invidiavano,invidiare,ind,imp,3,plur).
v(invidava,invidiare,ind,imp,3,sing).
v(ama,amare,ind,pres,3,sing).
v(amava,amare,ind,imp,3,sing).
v(ami,amare,cong,pres,_,sing).
v(preoccupa,preoccupare,ind,pres,3,sing).
v(ritiene,ritenere,ind,pres,3,sing).
v(promosse,promuovere,ind,pass_rem,3,sing).
v(pensi,pensare,cong,pres,3,sing).
v(pensa,pensare,ind,pres,3,sing).

v(ha,avere,ind,pres,3,sing).
v(hai,avere,ind,pres,2,sing).

v(e_,essere,ind,pres,3,sing).
v(sono,essere,ind,pres,3,plur).
v(sia,essere,cong,pres,3,sing).

/* AUSILIARE */

ausiliare(aux(Ainf,Modo,Tempo,Persona,Numero)) -->
 [Aux], { aux(Aux,Ainf,Modo,Tempo,Persona,Numero) } .

/* AUX */
           /* definizione del "fatto" ausiliare */

aux(viene,venire,ind,pres,3,sing).
aux(vengono,venire,ind,pres,3,plur).
aux(aveva,avere,ind,imp,3,sing).
aux(avevano,avere,ind,imp,3,plur).
aux(avrebbe,avere,cong,pass,3,sing).  /* che tempo ? */
aux(avere,avere,inf,pres,_,_).
aux(ha,avere,ind,pres,3,sing).
aux(ho,avere,ind,pres,1,sing).
aux(avere,avere,inf,_,_,_).
aux(sia,essere,cong,pres,_,sing).
aux(e_,essere,ind,pres,3,sing).
aux(era,essere,ind,imp,3,sing).
aux(sara_,essere,ind,futuro,3,sing).
aux(sta,stare,ind,pres,3,sing).
aux(stava,stare,ind,imp,3,sing).

/* PARTICIPIO */

participio(Verbo,Gen,Num) -->
 [X], {pp_x(X,Verbo,Gen,Num)} .

pp_x(X,V,mas,sing) :- pp(X,_,_,_,V).
pp_x(X,V,mas,plur) :- pp(_,X,_,_,V).
pp_x(X,V,fem,sing) :- pp(_,_,X,_,V).
pp_x(X,V,fem,plur) :- pp(_,_,_,X,V).

/* PP */
         /* definizione del "fatto" participio */

pp(controllato,controllati,controllata,controllate,controllare).
pp(corso,corsi,corsa,corse,correre).
pp(incaricato,incaricati,incaricata,incaricate,incaricare).
pp(rilevato,rilevati,rilevata,rilevate,rilevare).
pp(sfruttato,sfruttata,sfruttati,sfruttate,sfruttare).
pp(ereditato,ereditati,ereditata,ereditate,ereditare).
pp(accennato,accennati,accennata,accennate,accennare).
pp(ordinato,ordinati,ordinata,ordinate,ordinare).
pp(incontrato,incontrati,incontrata,incontrate,incontrare).
pp(perso,persa,persi,perse,perdere).
pp(rubato,rubati,rubata,rubate,rubare).
pp(detto,detti,detta,dette,dire).
pp(insultato,insultati,insultata,insultate,insultare).
pp(lasciato,lasciati,lasciata,lasciate,lasciare).
pp(fatto,fatti,fatta,fatte,fare).
pp(accusato,accusati,accusata,accusate,accusare).
pp(visto,visti,vista,viste,vedere).
pp(amato,amati,amata,amate,amare).
pp(nominato,nominati,nominata,nominate,nominare).
pp(mangiato,mangiati,mangiate,mangiata,mangiare).
pp(partito,partiti,partita,partite,arrivate).
pp(arrivato,arrivati,arrivata,arrivate,arrivare).
pp(stato,stati,stata,state,essere).
pp(avuto,avuti,avuta,avute,avere).
pp(cercato,cercati,cercata,cercate,cercare).
pp(aspettato,aspettati,aspettata,aspettate,aspettare).


/* PRED */
	   /* definizione del "fatto" pred per i verbi */

pred(verbo,accennare,intr,attivita,
	   [sn/sogg/tema_esper/[umano],sp/ogg2/tema_nonaff/a/[oggetto]]).
pred(verbo,accennare,trans,attivita,
	   [sn/sogg/tema_esper/[umano],sp/ogg2/tema_nonaff/a/[umano],


/* dire di .. e dire che .... */				   f/prop/[sogg=sogg/tema_esper,sogg=x]]).
pred(verbo,dire,trans,risultato,
		   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[umano],
		    svinf/prop/di/[sogg=tema_aff]]).
/* x sta per pro e sogg=x deve essere il secondo */
pred(verbo,dire,trans,riportivo,
	   [sn/sogg/agente/[umano],sp/ogg2/esperiente/a/[umano],
				   f/prop/[sogg=sogg/agente,sogg=x]]).
/* x sta per pro e sogg=x deve essere il secondo */
pred(verbo,attaccare,trans,attivita,
	   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[oggetto,sostanza]]).
pred(verbo,ordinare,trans,attivita, [sn/sogg/agente/[umano],
				       sp/ogg2/paziente/a/[umano],
				       svinf/prop/di/[sogg=ogg2/paziente]]).
pred(verbo,rilevare,trans,attivita,
	   [sn/sogg/tema_esper/[umano],sn/ogg/tema_nonaff/[aspetto,sostanza]]).
pred(verbo,rimuovere,trans,attivita,
	   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[umano,oggetto,sostanza]]).
pred(verbo,ripetere,trans,attivita,
	   [sn/sogg/agente/[umano],sn/ogg/tema_nonaff/[attivita]]).
pred(verbo,ripetere,intr,attivita,
	   [sn/sogg/agente/[umano]]).
pred(verbo,portare,trans,attivita,
	   [sn/sogg/agente/[umano],sp/ogg/tema_aff/a/[umano],
				   svinf/prop/di/[sogg=ogg/tema]]).
			



pred(verbo,avvisare,trans,attivita,
		   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[umano]]).
pred(verbo,controllare,trans,attivita,
		   [sn/sogg/agente/[umano],
		    sn/ogg/tema_aff/[oggetto,sostanza,misura,luogo,umano]]).
pred(verbo,correre,intr,cambiamento,
		   [sn/sogg/agente/[umano],sp/obl/tema_aff/da/[umano]]).
pred(verbo,correre,intr,cambiamento,
		   [sn/sogg/tema_aff/[umano],sp/obl/locativo/a/[luogo]]).

pred(verbo,correre,intr,attivita,
		   [sn/sogg/agente/[umano]]).
pred(verbo,parlare,intr,attivita,
		   [sn/sogg/tema_esper/[umano,oggetto],
                    sp/obl/subj_dis/di/[_]]).
pred(verbo,piacere,intr,emotivo,
		   [svinf/prop/[]/[sogg=ogg2/esperiente],
		    sp/ogg2/esperiente/a/[umano]]).
pred(verbo,piacere,intr,emotivo,
		   [sn/sogg/tema_emot/[oggetto,umano],
		    sp/ogg2/esperiente/a/[umano]]).
pred(verbo,sfruttare,trans,attivita,
		   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[evento,stato,umano]]).
pred(verbo,preferire,trans,soggettivo,
		   [sn/sogg/tema_esper/[umano],
		    svinf/prop/[]/[sogg=sogg/tema_esper]]).

pred(verbo,lasciare,supporto,attivita,[]).

pred(verbo,morire,intr,risultato,
		   [sn/sogg/tema_esper/[umano]]).

pred(verbo,perdere,trans,cambiamento,
		   [sn/sogg/tema_esper/[umano],
		    sn/ogg/tema_nonaff/[oggetto,evento,stato,umano]]).
pred(verbo,perdere,intr,cambiamento,
		   [sn/sogg/tema_esper/[umano]]).
pred(verbo,accettare,trans,risultato,
		   [sn/sogg/tema_esper/[umano],
		    sn/ogg/tema_nonaff/[oggetto,stato]]).
pred(verbo,mangiare,trans,risultato,
		   [sn/sogg/agente/[umano],
		    sn/ogg/tema_aff/[oggetto]]).
pred(verbo,tenere,trans,attivita,
		   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[stato]]).
pred(verbo,curare,trans,attivita,
		   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[umano,sociale,istituzione]]).
pred(verbo,corrispondere,intr,attivita,
		   [sn/sogg/esperiente/[attivita],sp/obl/tema_nonaff/a/[stato]]).
pred(verbo,sapere,trans,presuppositivo,
		   [sn/sogg/tema_esper/[umano],
		    svinf/prop/[]/[sogg=sogg/tema_esper]]).
/* sapere che... = nella fcomp non passa variabili di estraposizione */
pred(verbo,sapere,trans,presuppositivo,
		   [sn/sogg/tema_esper/[umano],
		    f/propf/[]/[sogg=sogg/tema_esper,sogg=x]]).
					/*  dovrebbe diventare
					f/fcomp/propf/[]/[sogg=sogg/tema_esper,sogg=x] */
pred(verbo,giostrare,intr,attivita,
		   [sn/sogg/agente/[umano],sp/obl/tema_eff/in/[attivita]]).
pred(verbo,ereditare,trans,risultato,
		   [sn/sogg/tema_esper/[umano],
		    sn/ogg/tema_nonaff/[evento,stato,istituzione]]).
pred(verbo,rassegnarsi,rifl_iner,soggettivo,
		   [sn/sogg/tema_esper/[umano],
		    svinf/prop/a/[sogg=sogg/tema_esper]]).
					/* dovrebbe diventare
					svinf/vcomp/prop/a/[sogg=sogg/tema_esper]
					il vcomp e_ un tipo di xcomp*/
pred(verbo,continuare,trans,attivita,
		   [sn/sogg/agente/[umano],svinf/prop/a/[sogg=sogg/agente]]).
pred(verbo,valersi,intr,attivita,
		   [sn/sogg/esperiente/[umano],
		    sp/obl/tema_nonaff/di/[umano,attivita]]).

pred(verbo,impressionare,trans,emotivo,
		   [sn/sogg/agente/[umano,stato],sn/ogg/tema_emot/[umano]]).
pred(verbo,confermare,trans,attivita,
		   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[umano,evento],
		    sp/obl/tema_nonaff/in/[attivita]]).
pred(verbo,funzionare,intr,attivita,
		   [sn/sogg/tema_esper/[umano],sp/obl/tema_nonaff/come/[umano]]).
pred(verbo,mobilitare,trans,attivita,
		   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[umano]]).

pred(verbo,battere,trans,attivita,
		   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[umano,animato]]).
pred(verbo,spronare,trans,attivita,
		   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[umano,animato]]).
pred(verbo,aspettare,trans,attivita,
		   [sn/sogg/tema_esper/[umano],sn/ogg/tema_nonaff/[umano]]).
pred(verbo,ubbidire,intr,attivita,
		   [sn/sogg/tema_eff/[umano,animato],
		       sp/obl/tema_esper/a/[umano,evento]]).
pred(verbo,provocare,trans,risultato,
		   [sn/sogg/causante/[emozione,evento],
		    sp/ogg2/esperiente/a/[umano],
		    sn/ogg/tema_eff/[evento,emozione]]).
pred(verbo,provocare,trans,risultato,
		   [sn/sogg/causante/[emozione,evento],
		    sn/ogg/tema_eff/[emozione,evento]]).
pred(verbo,avere,trans,stato,[sn/sogg/agente/[umano],
			      sn/ogg/tema_nonaff/[animato]]).
     /* Solo per analizzare le frasi dell'ASINO */

pred(verbo,incontrare,trans,risultato,
		   [sn/sogg/esperiente/[umano],sn/ogg/tema_esper/[umano]]).
pred(verbo,vedere,trans,percettivo,
		   [sn/sogg/esperiente/[umano],
		    sn/ogg/tema_nonaff/[umano,animato,oggetto],
					pcomp/locativo/[luogo]]).
pred(verbo,incontrare,trans,risultato,
		   [sn/sogg/esperiente/[umano],
		    sn/ogg/tema_esper/[umano,animato,oggetto],
					pcomp/locativo/[luogo]]).

pred(verbo,accusare,trans,risultato,
		   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[umano]]).
pred(verbo,accusare,trans,risultato,
		   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[umano],
		    svinf/prop/di/[sogg=tema_aff]]).



pred(verbo,insultare,trans,risultato,
		   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[umano]]).
pred(verbo,amare,trans,affettivo,
		   [sn/sogg/esperiente/[umano],
		    sn/ogg/tema_nonaff/[luogo,umano,animato]]).
pred(verbo,preoccupare,trans,emotivo,
		   [sn/sogg/tema_emot/[umano,stato],
		    sn/ogg/esperiente/[umano]]).
pred(verbo,invidiare,trans,soggettivo,
                   [sn/sogg/esperiente/[umano],sn/ogg/tema_nonaff/[_],
				   sp/ogg2/tema_esper/[umano]]).


/* copulativi */
pred(verbo,essere,copulativo,esistenza,[sn/sogg/tema_bound/[_],acomp/prop/[_]]).
pred(verbo,essere,copulativo,esistenza,[sn/sogg/tema_bound/[_],ncomp/prop/[_]]).
pred(verbo,essere,copulativo,esistenza,[sn/sogg/tema_bound/[_],pcomp/_Ruolo/[locativo,compagnia]]).  /* la categoria e' espressa in termine del tipo di sp */
pred(verbo,durare,copulativo,esistenza,[sn/sogg/tema_bound/[_],ncomp/prop/[tempo]]).
pred(verbo,durare,intr,esistenza,[sn/sogg/tema_bound/[_]]).
pred(verbo,sembrare,copulativo,esistenza,[sn/sogg/tema_bound/[_],acomp/prop/[_]]).
pred(verbo,diventare,copulativo,esistenza,[sn/sogg/tema_bound/[_],acomp/prop/[_]]).


pred(verbo,considerare,trans,soggettivo,[sn/sogg/esperiente/[umano],sn/ogg/tema_bound/[_],acomp/prop/[_]]).
pred(verbo,rendere,trans,attivita,[sn/sogg/agente/[_],sn/ogg/tema_bound/[_],acomp/prop/[_]]).
pred(verbo,nominare,trans,ist_soc,
		    [sn/sogg/agente/[umano],sn/ogg/tema_bound/[umano],
		     ncomp/prop/[umano]]).

pred(verbo,leggere,trans,attivita,
	   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[oggetto]]).
pred(verbo,bere,trans,attivita,
	   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[sostanza]]).
pred(verbo,regalare,trans,risultato,
		   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[oggetto],
		    sp/ogg2/esperiente/a/[umano]]).
pred(verbo,rubare,trans,attivita,
		   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[oggetto],
		    sp/ogg2/paziente/a/[umano]]).
pred(verbo,partire,intr,cambiamento,
		   [sn/sogg/agente/[umano]]).
pred(verbo,arrivare,intr,cambiamento,
		   [sn/sogg/agente/[umano]]).

pred(verbo,fare,trans,attivita,
		   [sn/sogg/agente/[umano],sp/ogg2/paziente/a/[umano],
		    svinf/prop/[]/[sogg=ogg2/paziente]]).

pred(verbo,vedere,trans,percettivo,
		   [sn/sogg/esperiente/[umano],
		    sn/ogg/tema_nonaff/[umano,animato,oggetto]]).
pred(verbo,vedere,trans,percettivo,
		   [sn/sogg/esperiente/[umano],
		    sn/ogg/tema_nonaff/[umano,animato,oggetto]]).
pred(verbo,sposare,trans,risultato,
		   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[umano]]).
pred(verbo,interrogare,trans,attivita,
		   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[umano]]).
pred(verbo,ritenere,trans,soggettivo,
	   [sn/sogg/esperiente/[umano],f/prop/[sogg=sogg/esperiente,sogg=x]]).
pred(verbo,promuovere,trans,risultato,
	   [sn/sogg/agente/[umano],sn/ogg/tema_aff/[umano]]).
pred(verbo,pensare,intr,attivita,
		   [sn/sogg/tema_esper/[umano],
                    sp/obl/tema_nonaff/a/_]).
pred(verbo,pensare,trans,attivita,
	   [sn/sogg/esperiente/[umano],f/prop/[sogg=sogg/esperiente,sogg=x]]).

pred(verbo,cercare,trans,attivita,
		   [sn/sogg/agente/[umano],sn/ogg/tema_nonaff/[umano]]).


	     /* definizione del "fatto" pred per i nomi */

pred(nome,area,[luogo],[]).
pred(nome,aria,[sostanza],[]).
pred(nome,attacco,[evento],[]).
pred(nome,bordo,[luogo],[]).
pred(nome,capoturno,[umano,sociale],[]).
pred(nome,controllo,[attivita],[]).
pred(nome,croce,[oggetto],[]).
pred(nome,difettosita_,[aspetto],[]).
pred(nome,dispositivo,[strumento],[]).
pred(nome,fetta,[oggetto],[]).
pred(nome,formazione,[evento],[]).
pred(nome,grado,[misura],[]).
pred(nome,linea,[luogo],[]).
pred(nome,mese,[tempo],[]).
pred(nome,metodo,[attivita],[]).
pred(nome,microscopio,[strumento],[]).
pred(nome,minuto,[tempo],[]).
pred(nome,operaio,[umano,sociale],[]).
pred(nome,uomo,[umano],[]).
pred(nome,operazione,[attivita],[]).
pred(nome,percorso,[luogo],[]).
pred(nome,punto,[luogo],[]).
pred(nome,serie,[misura],[]).
pred(nome,settimana,[tempo],[]).
pred(nome,sollevamento,[evento],[]).
pred(nome,spessore,[spazio],[]).
pred(nome,stufa,[strumento],[]).
pred(nome,temperatura,[misura],[]).
pred(nome,tempo,[tempo],[]).
pred(nome,sporco,[stato],[]).
pred(nome,volta,[ripetizione],[]).


pred(nome,mela,[oggetto],[]).
pred(nome,occasione,[evento],[]).
pred(nome,suocero,[umano,relazionale],[sn/sogg/possessore/[umano]]).
pred(nome,posto,[stato],[sp/obl/locativo/in/[istituzione]]).
pred(nome,organizzazione,[istituzione],[sn/sogg/tema_nonaff/[evento]]).
pred(nome,fiera,[evento],[sn/ogg/tema/[luogo]]).
pred(nome,delegato,[umano,sociale],[]).
pred(nome,funzionario,[umano,sociale],[]).
pred(nome,incarico,[attivita],[svinf/prop/di/[sogg=x]]).
pred(nome,incarico,[attivita],[sp/obl/locativo/a/[evento]]).
pred(nome,rapporto,[stato],[sp/obl/tema_nonaff/con/[umano,istituzione]]).
pred(nome,rapporto,[oggetto],[]).
pred(nome,delegazione,[umano,sociale,istituzione],[]).
pred(nome,produttore,[umano,sociale,istituzione],[]).
pred(nome,ditta,[umano,sociale,istituzione],[]).
pred(nome,stampa,[umano,sociale,istituzione],[]).
pred(nome,compito,[attivita],[]).
pred(nome,vocazione,[stato],[sn/sogg/possessore/[umano]]).
pred(nome,agilita_,[stato],[]).
pred(nome,collegio,[istituzione],[sn/sogg/possessore/[umano]]).
pred(nome,presidenza,[umano,istituzione],[sn/ogg/tema_nonaff/[evento,stato]]).
pred(nome,collaborazione,[attivita],[sn/sogg/agente/[umano]]).
pred(nome,commercio,[attivita],[sn/sogg/agente/[umano]]).
pred(nome,distinzione,[stato],[sn/sogg/possessore/[umano]]).
pred(nome,segretario,[umano,sociale],[sn/ogg/tema_nonaff/[umano,istituzione]]).
pred(nome,prefetto,[umano,sociale],[]).
pred(nome,questore,[umano,sociale],[]).
pred(nome,ex_ufficiale,[umano,sociale],[sn/ogg/tema/[istituzione]]).
pred(nome,ministro,[umano,sociale],[sn/ogg/tema/[istituzione,attivita]]).


pred(nome,padrone,[umano],[]).
pred(nome,asino,[animato],[]).
pred(nome,toro,[animato],[]).
pred(nome,libro,[oggetto],[]).
pred(nome,giocattolo,[oggetto],[]).
pred(nome,cannocchiale,[oggetto],[]).
pred(nome,ragazzo,[umano],[]).
pred(nome,ragazza,[umano],[]).
pred(nome,mamma,[umano,relazionale],[]).
pred(nome,biblioteca,[luogo],[]).
pred(nome,dispiacere,[emozione],[]).
pred(nome,partenza,[evento],[sn/sogg/tema_esp/[umano,oggetto]]).
pred(nome,imputato,[umano],[]).
pred(nome,casa,[luogo],[]).
pred(nome,treno,[luogo,strumento],[]).
pred(nome,autobus,[luogo,strumento],[]).
pred(nome,finestra,[luogo,oggetto],[]).
pred(nome,salute,[stato],[sn/sogg/tema/[umano]]).
pred(nome,moglie,[umano,relazionale],[]).
pred(nome,sorella,[umano,relazionale],[]).
pred(nome,fratello,[umano,relazionale],[]).
pred(nome,madre,[umano,relazionale],[sn/sogg/tema/[umano]]).
pred(nome,famiglia,[umano,istituzione],[]).
pred(nome,padre,[umano,relazionale],[]).
pred(nome,persona,[umano],[]).
pred(nome,bambino,[umano],[]).
pred(nome,insegnante,[umano],[]).
pred(nome,studente,[umano],[]).
pred(nome,liberta_,[stato],[]).
pred(nome,film,[oggetto],[]).
pred(nome,genio,[umano],[]).
pred(nome,trasmissione,[oggetto],[]).
pred(nome,storia,[evento],[]).
pred(nome,ora,[tempo],[]).
pred(nome,giorno,[tempo],[]).
pred(nome,tre,[tempo],[]).

/* nomi propri */

pred(nopro,avveduti,[umano],[]).
pred(nopro,verona,[luogo],[]).
pred(nopro,alberti,[umano],[]).
pred(nopro,trabucchi,[umano],[]).
pred(nopro,1950,[tempo],[]).
pred(nopro,novara_cavalleria,[istituzione],[]).

pred(nopro,marco,[umano],[]).
pred(nopro,mario,[umano],[]).
pred(nopro,maria,[umano],[]).
pred(nopro,francesca,[umano],[]).
pred(nopro,luigi,[umano],[]).
pred(nopro,gino,[umano],[]).
pred(nopro,'Bob',[umano],[]).
pred(nopro,'Gabriella',[umano],[]).

/*------------------------------------------------------------------------*/
/*GENERAZIONE DI SIMBOLI                                                  */
/*LA CHIAMATA gen_sym(Radice,0) INIZIALIZZA IL GENERATORE PER LA RADICE   */
/*------------------------------------------------------------------------*/

gen_sym(Radice,X) :- nonvar(X), !, X = 0,
		    retractall(current_num(Radice,_N)).

gen_sym(Radice,Atomo) :- get_num(Radice,Num),
			name(Radice,Name1),
			name(Num,Name2),
			append(Name1,Name2,Name),
			name(Atomo,Name).

get_num(Radice,Num) :- retract(current_num(Radice,Num1)), !,
		       Num is Num1 + 1,
		       assert(current_num(Radice,Num)).
get_num(Radice,1)   :- assert(current_num(Radice,1)).

/* RETRACTALL */

retractall(X) :- retract(X),fail.
retractall(_).

/*------------------------------------------------------------------------*/
/*GENERAZIONE DI UNA STAMPA AD ALBERO:PRETTY PRINT                        */
/*------------------------------------------------------------------------*/

/* PPP */

ppp(X,I) :- atomic(X),tab(I),write(X),nl, !.
ppp([],I) :- tab(I),write([]),nl,!.
ppp([H|T],I) :- !,
          J is I + 1, ppp(H,J), ppx(T,J),
          !.
ppp(Struttura,I) :- Struttura =.. [Func|[[]]],
          tab(I),write(Func),tab(1),write([]),nl,!.
ppp(Struttura,I) :- Struttura =.. [Func|_],
          member(Func,
  [sem,artic,regola,indice,n,npro,pr,prorel,a,v,aux,supporto,
          pp,def,part,card,prep,cat,sub,controllore,ruolo,implicito,
          possessivo]),
          tab(I),write(Struttura),nl,!.
ppp(Struttura,I) :- Struttura =.. [Func|Args],tab(I),write(Func),nl,
          J is I + 1, ppp(Args,J),!.

/* PPX */

ppx([],_) :- !.
ppx([H|T],I) :- ppp(H,I), ppx(T,I), !.


