<

/*  Patente.pl       Sett  97    */

/* Esempio di uso del KLONE  */

* per caricare l'ambiente KLONE */

:- consult('/home2/httpd/html/research/HYPERPROLOG/esempi/klone/klone').


/* Definizione di concetti   */

doc_identita :-

 /* Definisce i concetti generici utilizzati */
    assume(generic_concept(thing)),
    assume(generic_concept(doc_identita)),
    assume(generic_concept(testo)),
    assume(generic_concept(data)),

 /* Tutti i concetti sono sussunti da thing */
    assume(has_super_concept(doc_identita,thing)),
    assume(has_super_concept(testo,thing)),
    assume(has_super_concept(data,thing)),

 /* Definizione dei ruoli */
    add(doc_identita,cognome,generic_role),
    add(doc_identita,nome,generic_role),
    add(doc_identita,data_nascita,generic_role),
    add(doc_identita,luogo_nascita,generic_role),
    add(doc_identita,residenza,generic_role),
    add(doc_identita,via,generic_role),

 /* Il filler del ruolo deve appartenere ad un certo ruolo generico value/restriction     */
    assume(has_vr(cognome,doc_identita,testo)),
    assume(has_vr(nome,doc_identita,testo)),
    assume(has_vr(data_nascita,doc_identita,data)),
    assume(has_vr(luogo_nascita,doc_identita,testo)),
    assume(has_vr(residenza,doc_identita,testo)),
    assume(has_vr(via,doc_identita,testo)),

 /* Fissa il numero di possibili fillers dei ruoli */
    assume(has_number(cognome,doc_identita,[1,1])),
    assume(has_number(nome,doc_identita,[1,1])),
    assume(has_number(data_nascita,doc_identita,[1,1])),
    assume(has_number(luogo_nascita,doc_identita,[1,1])),
    assume(has_number(residenza,doc_identita,[1,1])),
    assume(has_number(via,doc_identita,[1,1])),

 /* La modalita' di body e' obbligatoria (opt e' il valore di default) */
    assume(has_modality(nome,doc_identita,obl)),
    assume(has_modality(cognome,doc_identita,obl)),
    assume(has_modality(data_nascita,doc_identita,obl)),
    assume(has_modality(luogo_nascita,doc_identita,obl)),
    assume(has_modality(residenza,doc_identita,obl)),
    assume(has_modality(via,doc_identita,obl)).


patente :-

 /* Definisce i concetti generici utilizzati */
    assume(generic_concept(patente)),
   
 /* Ha come super-concetto doc_identita */
    assume(has_super_concept(patente,doc_identita)),

 /* Definizione dei ruoli */
    add(patente,prefetto_di,generic_role),
    add(patente,data_rilascio,generic_role),
    add(patente,data_scadenza,generic_role),
    add(patente,numero,generic_role),
    add(patente,tipo,generic_role),

 /* Il filler del ruolo deve appartenere ad un certo ruolo generico value/restriction     */
    assume(has_vr(prefetto_di,patente,testo)),
    assume(has_vr(data_rilascio,patente,data)),
    assume(has_vr(data_scadenza,patente,data)),
    assume(has_vr(numero,patente,testo)),
    assume(has_vr(tipo,patente,testo)),

 /* Fissa il numero di possibili fillers dei ruoli */
    assume(has_number(prefetto_di,patente,[1,1])),
    assume(has_number(data_rilascio,patente,[1,1])),
    assume(has_number(data_scadenza,patente,[1,1])),
    assume(has_number(numero,patente,[1,1])),
    assume(has_number(tipo,patente,[1,1])),

 /* La modalita' di body e' obbligatoria (opt e' il valore di default) */

    assume(has_modality(prefetto_di,patente,obl)),
    assume(has_modality(data_rilascio,patente,obl)),
    assume(has_modality(data_scadenza,patente,obl)),
    assume(has_modality(numero,patente,obl)),
    assume(has_modality(tipo,patente,obl)).


inizializza :-
    generici,
    individuali.


generici :-
    clear_net,
    doc_identita,
    stampa(doc_identita),
    patente,
    stampa(patente).


individuali :-

   assume(individual_concept(25/10/1975)),
   assume(individuates(25/10/1975,data)),

   assume(individual_concept(15/11/1993)),
   assume(individuates(15/11/1993,data)),

   assume(individual_concept(15/11/2003)),
   assume(individuates(15/11/2003,data)),

   assume(individual_concept(mario)),
   assume(individuates(mario,testo)),

   assume(individual_concept(rossi)),
   assume(individuates(rossi,testo)),

   assume(individual_concept(pavia)),
   assume(individuates(pavia,testo)),

   assume(individual_concept(parma)),
   assume(individuates(parma,testo)),

   assume(individual_concept(aj8b44012i4p3r)),
   assume(individuates(aj8b44012i4p3r,testo)),

   assume(individual_concept([via,cacciatori,delle,alpi])),
   assume(individuates([via,cacciatori,delle,alpi],testo)),

   assume(individual_concept(pat1)),
   assume(individuates(pat1,patente)).


/*  Una particolare Patente */
pat1 :-

   add(pat1,nome1,instance_role),
   assume(satisfies(nome1,pat1,nome,patente)),
   assume(has_value(nome1,pat1,mario)),

   add(pat1,cognome1,instance_role),
   assume(satisfies(cognome1,pat1,cognome,patente)),
   assume(has_value(cognome1,pat1,rossi)),

   add(pat1,luogo_nascita1,instance_role),
   assume(satisfies(luogo_nascita1,pat1,luogo_nascita,patente)),
   assume(has_value(luogo_nascita1,pat1,pavia)),

   add(pat1,data_nascita1,instance_role),
   assume(satisfies(data_nascita1,pat1,data_nascita,patente)),
   assume(has_value(data_nascita1,pat1,25/10/1975)),

   add(pat1,residenza1,instance_role),
   assume(satisfies(residenza1,pat1,residenza,patente)),
   assume(has_value(residenza1,pat1,parma)),

   add(pat1,via1,instance_role),
   assume(satisfies(via1,pat1,via,patente)),
   assume(has_value(via1,pat1,[via,cacciatori,delle,alpi])),

   add(pat1,prefetto_di1,instance_role),
   assume(satisfies(prefetto_di1,pat1,prefetto_di,patente)),
   assume(has_value(prefetto_di1,pat1,parma)),

   add(pat1,data_rilascio1,instance_role),
   assume(satisfies(data_rilascio1,pat1,data_rilascio,patente)),
   assume(has_value(data_rilascio1,pat1,15/11/1993)),

   add(pat1,data_scadenza1,instance_role),
   assume(satisfies(data_scadenza1,pat1,data_scadenza,patente)),
   assume(has_value(data_scadenza1,pat1,15/11/2003)),

   add(pat1,numero1,instance_role),
   assume(satisfies(numero1,pat1,numero,patente)),
   assume(has_value(numero1,pat1,aj8b44012i4p3r)).





/*Procedure di supporto*/

stampa(A) :-
   generic_concept(A),
   print_header(g_conc,A),
   print_section(super_c,A,fullview),
   print_section(roles,A,fullview),
   skip_line(1).

pp(I_conc) :-
            individual_concept(I_conc),
            write(I_conc),write(' e_ un concetto individiale'),nl,
            individuates(I_conc,G_conc), !,
            write(I_conc),write(' e_ un '),write(G_conc),nl,
            stampa_ruoli(I_conc,G_conc).

stampa_ruoli(I_conc,G_conc) :-
             has_role(I_conc,I_role),
             write(I_role),write(' e_ un instance_role '),nl, 
             satisfies(I_role,I_conc,G_role,G_conc),
             write(' che individua un '),write(G_role),
             write(' di '),write(G_conc),
             stampa_valore(I_role,I_conc,Value),
             fail.
stampa_ruoli(_,_).

stampa_valore(Ir,Ic,V):- has_value(Ir,Ic,V),
                         write('  con valore '),write(V),nl,!.
stampa_valore(Ir,Ic,V):- write(' che non ha nessun valore '),nl,!.


