
/*     MESSAGGIO.PL       sett  91    */

/* esempi di uso del KLONE  */

* per caricare l'ambiente KLONE */

:- consult('/home2/httpd/html/research/HYPERPROLOG/esempi/klone/klone').

/* definizione di concetti  */

message :-

 /* definisce i concetti generici utilizzati */ 
    assume(generic_concept(thing)),
    assume(generic_concept(message)),
    assume(generic_concept(person)),
    assume(generic_concept(text)),
    assume(generic_concept(date)),

 /* tutti i concetti sono sussunti da thing */
    assume(has_super_concept(message,thing)),
    assume(has_super_concept(person,thing)),
    assume(has_super_concept(date,thing)),
    assume(has_super_concept(text,thing)),

 /* definizione dei ruoli del messaggio */
    add(message,sender,generic_role),
    add(message,recipient,generic_role),
    add(message,body,generic_role),
    add(message,send_date,generic_role),
    add(message,received_date,generic_role),

 /* il filler del ruolo deve appartenere ad un certo ruolo generico 
     value/restriction     */
    assume(has_vr(sender,message,person)),
    assume(has_vr(recipient,message,person)),
    assume(has_vr(body,message,text)),
    assume(has_vr(send_date,message,date)),
    assume(has_vr(received_date,message,date)),

 /* fissa il numero di possibili fillers dei ruoli */
    /* assume(has_number(sender,message,[1,nil])),   default !! */
    /* assume(has_number(recipient,message,[1,nil])),    default !! */
    assume(has_number(body,message,[1,1])),
    assume(has_number(send_date,message,[1,1])),
    assume(has_number(received_date,message,[1,1])),

 /* la modalita' di body e' obbligatoria (opt e' il valore di default) */
    assume(has_modality(body,message,obl)).




/* messaggio privato : e' un messaggio con un solo recipient  */

private_message :-

   /* private_message e' un concetto generico */      
   assume(generic_concept(private_message)), 

   /* ha come super-concetto messaggio */
   assume(has_super_concept(private_message,message)),

   /* il messaggio privato ha un unico recipient */
   assume(has_number(recipient,private_message,[1,1])).


/* starfleet_message : un messaggio il cui sendert e' 
      uno starfleet_commander   */

starfleet_message :-

/* starfleet_message e' un concetto genenerico
   che ha per super concetto message */
  assume(generic_concept(starfleet_message)),
  assume(has_super_concept(starfleet_message,message)),

/* starfleet_commander e' un concetto generico
   che ha come super concetto persona */
  assume(generic_concept(starfleet_commander)),
  assume(has_super_concept(starfleet_commander,person)),

/* il valore/restrizione di sender non e' piu'
   persona ma starfleet_commander   */
  assume(has_vr(sender,starfleet_message,starfleet_commander)).  


/* starfleet_private_message */
starfleet_private_message :-
  assume(generic_concept(starfleet_private_message)),
  assume(has_super_concept(starfleet_private_message,private_message)),
  assume(has_super_concept(starfleet_private_message,starfleet_message)).



/* cc_message : differenzia il ruolo recipient in to_recipient
                e cc_recipient */

cc_message :- 

% cc_message e' un concetto generico
              assume(generic_concept(cc_message)),

% ha come super concetto message              
              assume(has_super_concept(cc_message,message)),

% i ruoli locali sono to_recipient e cc_recipient
              add(cc_message,to_recipient,generic_role),
              add(cc_message,cc_recipient,generic_role),

% to_recipient e cc_recipient differenziano recipient
              assume(
                differentiates(to_recipient,cc_message,
                               recipient,message)),
              assume(
                differentiates(cc_recipient,cc_message,
                               recipient,message)),

% un ruolo differenziato puo'avere altre restrizioni 
              assume(generic_concept(commander)),
              assume(has_vr(to_recipient,cc_message,commander)).




generici:-
  clear_net,
  message,
  pretty_print1(message),
  private_message,
  pretty_print(private_message),
  pretty_print1(recipient,private_message),
  starfleet_message,
  pretty_print(starfleet_message),
  pretty_print1(sender,starfleet_message),
  starfleet_private_message,
  pretty_print(starfleet_private_message),
  pretty_print1(sender,starfleet_private_message),
  pretty_print1(recipient,starfleet_private_message),
  cc_message,
  pretty_print(cc_message).



/* concetti individuali  */

/* kirk e' uno starfleet-commander
   sulu e scotty sono enterprise-crew-member */
individui :-

% kirk
  assume(individual_concept(kirk)),
  assume(individuates(kirk,starfleet_commander)),

% membri dell'equipaggio dell' Enterprise
  assume(generic_concept(enterprise_crew_member)),
  assume(has_super_concept(enterprise_crew_member,person)),

% sulu
  assume(individual_concept(sulu)),
  assume(individuates(sulu,enterprise_crew_member)),

% scotty
  assume(individual_concept(scotty)),
  assume(individuates(scotty,enterprise_crew_member)),

% una data
  assume(individual_concept(mm:5/dd:21/yy:2017)),
  assume(individuates(mm:5/dd:21/yy:2017,date)),

% il testo di un messaggio
  assume(individual_concept([return,to,starfleet,command,immediately])),
  assume(individuates([return,to,starfleet,command,immediately],text)),

% un (particolare) messaggio
  assume(individual_concept(msg1)),
  assume(individuates(msg1,cc_message)).
  

msg1 :- 

% PARTICULAR ROLE SET

% un cc_recipient deve essere un enterprise_crew_member 
  assume(has_vr(cc_recipient,msg1,enterprise_crew_member)),

% INSTANCE ROLES

%sender_1 
  add(msg1,sender_1,instance_role),
  assume(satisfies(sender_1,msg1,sender,cc_message)),

%to_recipient_1
  add(msg1,to_recipient_1,instance_role),
  assume(satisfies(to_recipient_1,msg1,to_recipient,cc_message)),
  assume(has_value(to_recipient_1,msg1,kirk)),

%cc_recipient_1
  add(msg1,cc_recipient_1,instance_role),
  assume(satisfies(cc_recipient_1,msg1,cc_recipient,cc_message)),
  assume(has_value(cc_recipient_1,msg1,sulu)),

%cc_recipient_2
  add(msg1,cc_recipient_2,instance_role),
  assume(satisfies(cc_recipient_2,msg1,cc_recipient,cc_message)),
  assume(has_value(cc_recipient_2,msg1,scotty)),

%send_date_1
  add(msg1,send_date_1,instance_role),
  assume(satisfies(send_date_1,msg1,send_date,cc_message)),
  assume(has_value(send_date_1,msg1,mm:5/dd:21/yy:2017)),

%received_date_1
  add(msg1,received_date_1,instance_role),
  assume(satisfies(received_date_1,msg1,received_date,cc_message)),

%body_1
  add(msg1,body_1,instance_role),
  assume(satisfies(body_1,msg1,body,cc_message)),
  assume(has_value(body_1,msg1,[return,to,starfleet,command,immediately])).


/* mario,andrea e giovanni sono persone */
persone:-
  assume(individual_concept(mario)),
  assume(individuates(mario,person)),
  assume(individual_concept(andrea)),
  assume(individuates(andrea,person)),
  assume(individual_concept(giovanni)),
  assume(individuates(giovanni,person)), 
  assume(individual_concept(kirk)),
  assume(individuates(kirk,starfleet_commander)).
  




/* m1 e' un messaggio */
m1:-
  assume(individual_concept(m1)),
  assume(individuates(m1,message)),
  /* sender1 e' un instance_role di m1 */
  add(m1,sender1,instance_role), /*  assume(instance_role(sender1)),*/
%  assume(has_role(m1,sender1)),
  assume(satisfies(sender1,m1,sender,message)),
  /* recipient1 e' un instance_role di m1 */
  add(m1,recipient1,instance_role), /*  assume(instance_role(sender1)),*/
%  assume(has_role(m1,recipient1)),
  assume(satisfies(recipient1,m1,recipient,message)),
  /* recipient2 e' un instance_role di m1 */
  add(m1,recipient2,instance_role), /*  assume(instance_role(sender1)),*/
  assume(has_role(m1,recipient2)),
  assume(satisfies(recipient2,m1,recipient,message)),
  
/* il sender del messaggio m1 e' mario */
  assume(has_value(sender1,m1,mario)).




/* m2 e' un messaggio */
m2:-
  assume(individual_concept(m2)),
  assume(individuates(m2,starfleet_message)),
  /* sender1 e' un instance_role di m1 */
  add(m2,sender1,instance_role), /*  assume(instance_role(sender1)),*/
  assume(has_role(m2,sender1)),
  assume(satisfies(sender1,m2,sender,starfleet_message)).

/* m3 e' un messaggio_privato 
      sbagliato !!!!!! deve esserci un unico recipient  */
m3:-
  assume(individual_concept(m3)),
  assume(individuates(m3,private_message)),
  /* sender1 e' un instance_role di m3 */
  add(m3,sender1,instance_role), 
  assume(has_role(m3,sender1)),
  assume(satisfies(sender1,m3,sender,private_message)),
  /* recipient1 e' un instance_role di m3 */
  add(m3,recipient1,instance_role), 
  assume(has_role(m3,recipient1)),
  assume(satisfies(recipient1,m3,recipient,private_message)),
  /* recipient2 e' un instance_role di m3 */
  add(m3,recipient2,instance_role),
  assume(has_role(m3,recipient2)),
  assume(satisfies(recipient2,m3,recipient,private_message)).
  





/* pretty print di un concetto individuale */

pp(I_conc) :-
            individual_concept(I_conc),
            write(I_conc),write(' e_ un concetto individiale'),nl,
            individuates(I_conc,G_conc), !,
            write(I_conc),write(' e_ un '),write(G_conc),nl,
            stampa_ruoli(I_conc,G_conc).

stampa_ruoli(I_conc,G_conc) :-
             has_role(I_conc,I_role),
             write(I_role),write(' e_ un instance_role '),nl, 
             satisfies(I_role,I_conc,G_role,G_conc),
             write(' che individua il '),write(G_role),
             write(' di '),write(G_conc),
             stampa_valore(I_role,I_conc,Value),
             fail.
stampa_ruoli(_,_).

stampa_valore(Ir,Ic,V):- has_value(Ir,Ic,V),
                         write('  valore '),write(V),nl,!.
stampa_valore(Ir,Ic,V):- write(' non ha nessun valore '),nl,!.
             


/* assegna valore a un instance_role di un individual_concetpt */
             
assegna_valore(Valore,Ir,Ic) :-
             individuates(Ic,Gc),
             satisfies(Ir,Ic,Gr,Gc),
             has_vr(Gr,Gc,VR),
             (individuates(Valore,VR),
             assume(has_value(Ir,Ic,Valore)),!;
             write(Valore),write(' non e_ '),write(VR),nl).

pretty_print1(A,B) :-
   generic_role(A),
   print_header(g_role,A),
   print_section(concept,A,B,nonfullview),
   print_section(super_r,A,B,fullview),
   print_section(facets,A,B,fullview),
   skip_line(1).

pretty_print1(A) :-
   generic_concept(A),
   print_header(g_conc,A),
   print_section(super_c,A,nonfullview),
   print_section(roles,A,fullview),
   skip_line(1).
pretty_print1(A) :-
   individual_concept(A),
   print_header(i_conc,A),
   print_section(indiv_c,A,nonfullview),
   print_section(roles,A,fullview),
   skip_line(1).
pretty_print1(A) :-
   work(B),
   net_node(g_role,A,C,B),
   print_header(g_role,A),
   print_section(concept,A,C,nonfullview),
   print_section(super_r,A,C,nonfullview),
   print_section(facets,A,C,nonfullview),
   skip_line(1).
