/* computer.pl */

* per caricare l'ambiente KLONE */

:- consult('/home2/httpd/html/research/HYPERPROLOG/esempi/klone/klone').

/*  Esempio del computer */

pc_80:-
/* definisce i concetti generici utilizzati */ 
	assume(generic_concept(cosa)),
	assume(generic_concept(pc_80)),
	assume(generic_concept(corpo)),
	assume(generic_concept(input)),
	assume(generic_concept(output)),
	assume(generic_concept(in_out)),
	assume(generic_concept(memorie)),
	assume(generic_concept(u_elabo)),

/* tutti i concetti sono sussunti da cosa */
assume(has_super_concept(pc_80,cosa)),
assume(has_super_concept(corpo,cosa)),
assume(has_super_concept(input,cosa)),
assume(has_super_concept(output,cosa)),
assume(has_super_concept(in_out,cosa)),
assume(has_super_concept(memorie,cosa)),
assume(has_super_concept(u_elabo,cosa)),

 /* definizione deiruoli nel computer */
	add(pc_80,tastiera,generic_role),
	add(pc_80,scatola,generic_role),
   	add(pc_80,video,generic_role),
   	add(pc_80,drive,generic_role),
   	add(pc_80,memoria,generic_role),
   	add(pc_80,c_p_u,generic_role),

  /* definisco di che tipo sono i ruoli  */
assume(has_vr(scatola,pc_80,corpo)),
assume(has_vr(tastiera,pc_80,input)),
assume(has_vr(video,pc_80,output)),
assume(has_vr(drive,pc_80,in_out)),
assume(has_vr(memoria,pc_80,memorie)),
assume(has_vr(c_p_u,pc_80,u_elabo)),

 /* fissa il numero di possibili riempitori dei ruoli */
assume(has_number(tastiera,pc_80,[1,1])),
assume(has_number(scatola,pc_80,[1,1])),
assume(has_number(video,pc_80,[1,1])),
assume(has_number(drive,pc_80,[1,2])),
assume(has_number(memoria,pc_80,[1,1])),
assume(has_number(c_p_u,pc_80,[1,1])),
/* fissa la modalita'  dei ruoli nel computer 80*/
assume(has_modality(tastiera,pc_80,obl)),
assume(has_modality(video,pc_80,obl)),
assume(has_modality(scatola,pc_80,obl)),
assume(has_modality(drive,pc_80,obl)),
assume(has_modality(memoria,pc_80,obl)),
assume(has_modality(c_p_u,pc_80,obl)).

/* personal computer meta' anni 80*/

pc_85:-
 /* definisce il pc_85 come concetto generico */ 

	assume(generic_concept(pc_85)),
/* pc_85 deriva dal pc_80*/
assume(has_super_concept(pc_85,pc_80)),


/* aggiungo nuovi ruoli al pc_85*/
	add(pc_85,disco_fisso,generic_role),
	add(pc_85,co_pro_mat,generic_role),
	add(pc_85,stampante,generic_role),
/* descrivo il tipo del ruolo*/
assume(has_vr(disco_fisso,pc_85,memorie)),
assume(has_vr(stampante,pc_85,output)),
assume(has_vr(co_pro_mat,pc_85,u_elabo)),
/*il tipo di ruolo*/
 assume(has_number(disco_fisso,pc_85,[0,1])),
assume(has_number(stampante,pc_85,[0,1])),
 assume(has_number(co_pro_mat,pc_85,[0,1])).

/* personal computer primi anni 90*/

pc_90:-

    assume(generic_concept(pc_90)),

assume(has_super_concept(pc_90,pc_85)),

	add(pc_90,mouse,generic_role),
	add(pc_90,scheda_audio,generic_role),
	add(pc_90,lettore_cd,generic_role),
	add(pc_90,cash,generic_role),

assume(has_vr(mouse,pc_90,input)),
assume(has_vr(cash,pc_90,memorie)),
assume(has_vr(scheda_audio,pc_90,output)),
assume(has_vr(lettore_cd,pc_90,input)),



assume(has_number(disco_fisso,pc_90,[1,2])),
assume(has_number(lettore_cd,pc_90,[0,1])),
assume(has_number(scheda_audio,pc_90,[0,1])),
assume(has_number(drive,pc_90,[1,1])),
assume(has_number(mouse,pc_90,[1,1])),

assume(has_modality(disco_fisso,pc_90,obl)),
assume(has_modality(stampante,pc_90,obl)),
assume(has_modality(co_pro_mat,pc_90,obl)),
assume(has_modality(mouse,pc_90,obl)).


/*personal computer della seconda meta anni 90'*/

pc_95:-

	assume(generic_concept(pc_95)),

assume(has_super_concept(pc_95,pc_90)),

	add(pc_95,modem,generic_role),
	add(pc_95,zip,generic_role),
	add(pc_95,tele_camera,generic_role),

assume(has_vr(modem,pc_95,in_out)),
assume(has_vr(zip,pc_95,in_out)),
assume(has_vr(tele_camera,pc_95,in_out)),

assume(has_number(modem,pc_95,[1,1])),
assume(has_number(zip,pc_95,[1,1])),
assume(has_number(tele_camera,pc_95,[1,1])),

assume(has_modality(lettore_cd,pc_95,obl)),
assume(has_modality(scheda_audio,pc_95,obl)),
assume(has_modality(cash,pc_95,obl)).

/* personal_computer per internet */

pc_int:-

assume(generic_concept(pc_int)),

assume(has_super_concept(pc_int,pc_95)),

assume(has_modality(modem,pc_95,obl)).

internet:-
	assume(generic_concept(internet)),
assume(has_super_concept(internet,cosa)),

	add(internet,siti,generic_role),

assume(has_vr(siti,internet,pc_int)),

assume(has_modality(siti,internet,obl)).

/* concetti individuali  */

/* descrivo il mio computer */

mio_computer:-

 
%hard disk
assume(individual_concept(hd_80mb)),
assume(individuates(hd_80mb,disco_fisso)),

%ram
assume(individual_concept(ram_2mb)),
assume(individuates(ram_2mb,memoria)),

%cashe
assume(individual_concept(cashe_2k)),
assume(individuates(cashe_2k,cashe)),


%drive
assume(individual_concept(drive_144)),
assume(individuates(drive_144,drive)),

%video
assume(individual_concept(video_13p)),
assume(individuates(video_13p,video)),

%stampante
assume(individual_concept(epson_100)),
assume(individuates(epson_100,stampante)),

%mouse
assume(individual_concept(mouse_ibm)),
assume(individuates(mouse_ibm,mouse)),

%tastiera
assume(individual_concept(keyboard_ibm)),
assume(individuates(keyboard_ibm,tastiera)),

%corpo ps1
assume(individual_concept(corpo_ps1)),
assume(individuates(corpo_ps1,scatola)),

%cpu
assume(individual_concept(intel80386)),
assume(individuates(intel80386,c_p_u)),

%coprocessore
assume(individual_concept(intel80387)),
assume(individuates(intel80387,co_pro_mat)),

%ps1
assume(individual_concept(ps1)),
assume(individuates(ps1,pc_90)).



ps1:-

%hard_disk
  add(ps1,hd1,instance_role),
  assume(satisfies(hd1,ps1,disco_fisso,pc_90)),
  assume(has_value(hd1,ps1,hd_80mb)),

%ram
  add(ps1,ram1,instance_role),
  assume(satisfies(ram1,ps1,memoria,pc_90)),
  assume(has_value(ram1,ps1,ram_2mb)),

%cashe
  add(ps1,cashe1,instance_role),
  assume(satisfies(cashe1,ps1,cashe,pc_90)),
  assume(has_value(cashe1,ps1,cashe_2k)),

%drive
  add(ps1,drive1,instance_role),
  assume(satisfies(drive1,ps1,drive,pc_90)),
  assume(has_value(drive1,ps1,drive_144)),

%video
  add(ps1,video1,instance_role),
  assume(satisfies(video1,ps1,video,pc_90)),
  assume(has_value(video1,ps1,video_13p)),

%stampante
  add(ps1,stamp1,instance_role),
  assume(satisfies(stamp1,ps1,stampante,pc_90)),
  assume(has_value(stamp1,ps1,epson_100)),

%mouse
  add(ps1,mouse1,instance_role),
  assume(satisfies(mouse1,ps1,mouse,pc_90)),
  assume(has_value(mouse1,ps1,mouse_ibm)),

%tastiera
  add(ps1,tas1,instance_role),
  assume(satisfies(tas1,ps1,tastiera,pc_90)),
  assume(has_value(tas1,ps1,keyboard_ibm)),

%corpo
  add(ps1,corp1,instance_role),
  assume(satisfies(corp1,ps1,scatola,pc_90)),
  assume(has_value(corp1,ps1,corpo_ps1)),

%cpu
  add(ps1,cpu1,instance_role),
  assume(satisfies(cpu1,ps1,c_p_u,pc_90)),
  assume(has_value(cpu1,ps1,intel80386)),

%coprocessore
  add(ps1,copro1,instance_role),
  assume(satisfies(copro1,ps1,co_pro_mat,pc_90)),
  assume(has_value(copro1,ps1,intel80387)).

inizializza:-
	clear_net,
	pc_80,
	pc_85,
	pc_90,
	pc_95,
	pc_int,
	internet,
	mio_computer,
	ps1.

pp(I_conc) :-
            individual_concept(I_conc),
            write(I_conc),write(' e_ un concetto individiale'),nl,
            individuates(I_conc,G_conc), !,
            write(I_conc),write(' e_ un '),write(G_conc),nl,
            stampa_ruoli(I_conc,G_conc).


pretty_print1(A) :-
   generic_concept(A),
   print_header(g_conc,A),
   print_section(super_c,A,nonfullview),
   print_section(roles,A,fullview),
   skip_line(1).

stampa_ps1:-
	     ps1, 
             has_role(ps1,I_role),
             write(I_role),write(' e_ un instance_role '),nl, 
             satisfies(I_role,ps1,G_role,G_conc),
             write(' che individua il '),write(G_role),
             write(' del PS1 '),
             stampa_valore(I_role,ps1,Value),
             fail.

stampa_valore(Ir,Ic,V):- has_value(Ir,Ic,V),
                         write('  tipo '),write(V),nl,!.
stampa_valore(Ir,Ic,V):- write(' non ha nessun tipo '),nl,!.


