% file: cut/insiemi.pl

appartiene(X,[X|_]) :- !.
appartiene(X,[_|Y]) :- appartiene(X,Y).

incluso([],_).
incluso([X|C],Y) :-
  appartiene(X,Y),
  incluso(C,Y). 

intersezione([],_Y,[]).
intersezione([X|R],Y,[X|Z]) :-
  appartiene(X,Y),
  !,
  intersezione(R,Y,Z).
intersezione([_X|R],Y,Z) :- 
  intersezione(R,Y,Z).

unione([],X,X).
unione([X|C],Y,Z) :- 
  appartiene(X,Y),
  !,
  unione(C,Y,Z).
unione([X|C],Y,[X|Z]) :-
  unione(C,Y,Z).

/* possibili goal
appartiene(3,[2,5,6,3,1]).
incluso([3,2,5],[4,1,2,7,6,3,5]).
incluso([3,2,5,8],[4,1,2,7,6,3,5]).
intersezione([9,2,5,8],[4,1,2,7,6,3,5],L).
intersezione([9,0,10,8],[4,1,2,7,6,3,5],L).
unione([9,2,5,8],[4,1,2,7,6,3,5],L).
*/

