/* QUICKSORT */

quicksort([H|T],S) :-
    dividi(H,T,A,B),
    quicksort(A,A1),
    quicksort(B,B1),
    concatena(A1,[H|B1],S).
quicksort([],[]).

dividi(H,[A|X],[A|Y],Z) :-
    in_ordine(A,H),
    dividi(H,X,Y,Z),
    !.
dividi(H,[A|X],Y,[A|Z]) :-
    dividi(H,X,Y,Z).
dividi(_,[],[],[]).

in_ordine(A,B) :- A =< B.

concatena([],L,L).
concatena([H|T],L,[H|V]) :- concatena(T,L,V).


% Esempi:

% Goal(first): quicksort([7,5,8,4,3,1,5],X).
% Risposta:    X = [1, 3, 4, 5, 5, 7, 8]

